/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.aggregation;

import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;

public final class AvgAccumulator
extends FieldAccumulator {
    public AvgAccumulator(int pos, Class<?> fieldType) {
        super(pos);
        if (!Number.class.isAssignableFrom(fieldType)) {
            throw new IllegalStateException("Aggregation AVG cannot be applied to property of type " + fieldType.getName());
        }
    }

    @Override
    public void init(Object[] row) {
        Number value = (Number)row[this.pos];
        row[this.pos] = value != null ? new Avg(value.doubleValue(), 1L) : new Avg(0.0, 0L);
    }

    @Override
    public void update(Object[] srcRow, Object[] destRow) {
        Number value = (Number)srcRow[this.pos];
        if (value != null) {
            Avg avg = (Avg)destRow[this.pos];
            avg.update(value.doubleValue());
        }
    }

    @Override
    public void finish(Object[] row) {
        row[this.pos] = ((Avg)row[this.pos]).getValue();
    }

    private static class Avg {
        double sum;
        long count;

        Avg(double sum, long count) {
            this.sum = sum;
            this.count = count;
        }

        void update(double value) {
            this.sum += value;
            ++this.count;
        }

        Double getValue() {
            return this.count > 0L ? Double.valueOf(this.sum / (double)this.count) : null;
        }
    }
}

