/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.utils.ExecutorFactory;

public final class OrderedExecutorFactory
implements ExecutorFactory {
    private final Executor parent;

    public OrderedExecutorFactory(Executor parent) {
        this.parent = parent;
    }

    @Override
    public Executor getExecutor() {
        return new OrderedExecutor(this.parent);
    }

    private static final class OrderedExecutor
    implements Executor {
        private final ConcurrentLinkedQueue<Runnable> tasks = new ConcurrentLinkedQueue();
        private boolean running;
        private final Executor parent;
        private final Runnable runner;

        public OrderedExecutor(Executor parent) {
            this.parent = parent;
            this.runner = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        Runnable task;
                        if ((task = (Runnable)OrderedExecutor.this.tasks.poll()) == null) {
                            ConcurrentLinkedQueue concurrentLinkedQueue = OrderedExecutor.this.tasks;
                            synchronized (concurrentLinkedQueue) {
                                task = (Runnable)OrderedExecutor.this.tasks.poll();
                                if (task == null) {
                                    OrderedExecutor.this.running = false;
                                    return;
                                }
                            }
                        }
                        try {
                            task.run();
                            continue;
                        }
                        catch (ActiveMQInterruptedException e) {
                            ActiveMQClientLogger.LOGGER.debug("Interrupted Thread", e);
                            continue;
                        }
                        catch (Throwable t) {
                            ActiveMQClientLogger.LOGGER.caughtunexpectedThrowable(t);
                            continue;
                        }
                        break;
                    }
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            ConcurrentLinkedQueue<Runnable> concurrentLinkedQueue = this.tasks;
            synchronized (concurrentLinkedQueue) {
                this.tasks.add(command);
                if (!this.running) {
                    this.running = true;
                    this.parent.execute(this.runner);
                }
            }
        }

        public String toString() {
            return "OrderedExecutor(running=" + this.running + ", tasks=" + this.tasks + ")";
        }
    }
}

