/*
 * Decompiled with CFR 0.152.
 */
package javax.resource.spi.work;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EventObject;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;

public class WorkEvent
extends EventObject {
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final int TYPE_IDX = 0;
    private static final int WORK_IDX = 1;
    private static final int EXCPEPTION_IDX = 2;
    private static final int DURATION_IDX = 2;
    public static final int WORK_ACCEPTED = 1;
    public static final int WORK_REJECTED = 2;
    public static final int WORK_STARTED = 3;
    public static final int WORK_COMPLETED = 4;
    private int type;
    private Work work;
    private WorkException e;
    private long startDuration = -1L;

    public WorkEvent(Object source, int type, Work work, WorkException exc) {
        super(source);
        this.type = type;
        this.work = work;
        this.e = exc;
    }

    public WorkEvent(Object source, int type, Work work, WorkException exc, long startDuration) {
        this(source, type, work, exc);
        this.startDuration = startDuration;
    }

    public int getType() {
        return this.type;
    }

    public Work getWork() {
        return this.work;
    }

    public long getStartDuration() {
        return this.startDuration;
    }

    public WorkException getException() {
        return this.e;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        String name = serialPersistentFields[0].getName();
        this.type = fields.get(name, 0);
        name = serialPersistentFields[1].getName();
        this.work = (Work)fields.get(name, null);
        name = serialPersistentFields[2].getName();
        this.e = (WorkException)fields.get(name, null);
        name = serialPersistentFields[2].getName();
        this.startDuration = fields.get(name, 0L);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField fields = oos.putFields();
        String name = serialPersistentFields[0].getName();
        fields.put(name, this.type);
        name = serialPersistentFields[1].getName();
        fields.put(name, this.work);
        name = serialPersistentFields[2].getName();
        fields.put(name, this.e);
        name = serialPersistentFields[2].getName();
        fields.put(name, this.startDuration);
        oos.writeFields();
    }

    static {
        Boolean legacy = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Boolean run() {
                try {
                    if (System.getProperty("org.jboss.j2ee.LegacySerialization") != null) {
                        return Boolean.TRUE;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return Boolean.FALSE;
            }
        });
        if (Boolean.TRUE.equals(legacy)) {
            serialVersionUID = 6971276136970053051L;
            serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("type", Integer.TYPE), new ObjectStreamField("work", Work.class), new ObjectStreamField("e", WorkException.class), new ObjectStreamField("startDuration", Long.TYPE)};
        } else {
            serialVersionUID = -3063612635015047218L;
            serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("type", Integer.TYPE), new ObjectStreamField("work", Work.class), new ObjectStreamField("exception", WorkException.class), new ObjectStreamField("startDuration", Long.TYPE)};
        }
    }
}

