/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.coarse;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.MutableCacheEntry;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.jboss.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.jboss.MarshalledValue;
import org.wildfly.clustering.marshalling.jboss.Marshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.InfinispanImmutableSession;
import org.wildfly.clustering.web.infinispan.session.InfinispanSession;
import org.wildfly.clustering.web.infinispan.session.MutableSessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.MutableSessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionAccessMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataKey;
import org.wildfly.clustering.web.infinispan.session.SessionFactory;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionAccessMetaData;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionMetaData;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.coarse.CoarseSessionEntry;
import org.wildfly.clustering.web.infinispan.session.coarse.SessionAttributesKey;
import org.wildfly.clustering.web.session.ImmutableSession;
import org.wildfly.clustering.web.session.Session;
import org.wildfly.clustering.web.session.SessionContext;

public class CoarseSessionFactory<L>
implements SessionFactory<CoarseSessionEntry<L>, L> {
    private final SessionContext context;
    private final Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> creationMetaDataCache;
    private final Cache<SessionCreationMetaDataKey, SessionCreationMetaDataEntry<L>> findCreationMetaDataCache;
    private final Cache<SessionAccessMetaDataKey, SessionAccessMetaData> accessMetaDataCache;
    private final Cache<SessionAttributesKey, MarshalledValue<Map<String, Object>, MarshallingContext>> attributesCache;
    private final Marshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>, MarshallingContext> marshaller;
    private final LocalContextFactory<L> localContextFactory;

    public CoarseSessionFactory(Cache<? extends Key<String>, ?> cache, SessionContext context, Marshaller<Map<String, Object>, MarshalledValue<Map<String, Object>, MarshallingContext>, MarshallingContext> marshaller, LocalContextFactory<L> localContextFactory, boolean lockOnRead) {
        this.creationMetaDataCache = cache;
        this.findCreationMetaDataCache = lockOnRead ? this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}) : this.creationMetaDataCache;
        this.accessMetaDataCache = cache;
        this.attributesCache = cache;
        this.context = context;
        this.marshaller = marshaller;
        this.localContextFactory = localContextFactory;
    }

    @Override
    public Session<L> createSession(String id, CoarseSessionEntry<L> entry) {
        MutableCacheEntry<SessionCreationMetaData> creationMetaDataEntry = entry.getMutableSessionCreationMetaDataEntry();
        MutableCacheEntry<SessionAccessMetaData> accessMetaDataEntry = entry.getMutableSessionAccessMetaDataEntry();
        MutableCacheEntry<Map<String, Object>> attributesEntry = entry.getMutableAttributesEntry();
        MutableSessionCreationMetaData creationMetaData = new MutableSessionCreationMetaData((SessionCreationMetaData)creationMetaDataEntry.getValue(), creationMetaDataEntry.getMutator());
        MutableSessionAccessMetaData accessMetaData = new MutableSessionAccessMetaData((SessionAccessMetaData)accessMetaDataEntry.getValue(), accessMetaDataEntry.getMutator());
        SimpleSessionMetaData metaData = new SimpleSessionMetaData(creationMetaData, accessMetaData);
        CoarseSessionAttributes attributes = new CoarseSessionAttributes((Map)attributesEntry.getValue(), attributesEntry.getMutator(), (MarshallingContext)this.marshaller.getContext());
        return new InfinispanSession<L>(id, metaData, attributes, entry.getLocalContext(), this.localContextFactory, this.context, this);
    }

    @Override
    public ImmutableSession createImmutableSession(String id, CoarseSessionEntry<L> entry) {
        MutableCacheEntry<SessionCreationMetaData> creationMetaDataEntry = entry.getMutableSessionCreationMetaDataEntry();
        MutableCacheEntry<SessionAccessMetaData> accessMetaDataEntry = entry.getMutableSessionAccessMetaDataEntry();
        MutableCacheEntry<Map<String, Object>> attributesEntry = entry.getMutableAttributesEntry();
        SimpleSessionMetaData metaData = new SimpleSessionMetaData((SessionCreationMetaData)creationMetaDataEntry.getValue(), (SessionAccessMetaData)accessMetaDataEntry.getValue());
        CoarseImmutableSessionAttributes attributes = new CoarseImmutableSessionAttributes((Map)attributesEntry.getValue());
        return new InfinispanImmutableSession(id, metaData, attributes, this.context);
    }

    public CoarseSessionEntry<L> createValue(String id, Void context) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionCreationMetaDataEntry creationMetaDataEntry = new SessionCreationMetaDataEntry(new SimpleSessionCreationMetaData());
        SessionCreationMetaDataEntry existingCreationMetaDataEntry = (SessionCreationMetaDataEntry)this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)creationMetaDataKey, creationMetaDataEntry);
        Mutator creationMetaDataMutator = Mutator.PASSIVE;
        if (existingCreationMetaDataEntry != null) {
            creationMetaDataEntry = existingCreationMetaDataEntry;
            creationMetaDataMutator = new CacheEntryMutator(this.creationMetaDataCache, (Object)creationMetaDataKey, (Object)creationMetaDataEntry);
        }
        SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
        SessionAccessMetaData accessMetaData = new SimpleSessionAccessMetaData();
        Mutator accessMetaDataMutator = Mutator.PASSIVE;
        if (existingCreationMetaDataEntry == null) {
            this.accessMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)accessMetaDataKey, (Object)accessMetaData);
        } else {
            SessionAccessMetaData existingAccessMetaData = (SessionAccessMetaData)this.accessMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)accessMetaDataKey, (Object)accessMetaData);
            if (existingAccessMetaData != null) {
                accessMetaData = existingAccessMetaData;
                accessMetaDataMutator = new CacheEntryMutator(this.accessMetaDataCache, (Object)accessMetaDataKey, (Object)accessMetaData);
            }
        }
        SessionAttributesKey attributesKey = new SessionAttributesKey(id);
        Map attributes = new ConcurrentHashMap();
        MarshalledValue attributesValue = (MarshalledValue)this.marshaller.write(attributes);
        Mutator attributesMutator = Mutator.PASSIVE;
        if (existingCreationMetaDataEntry == null) {
            this.attributesCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)attributesKey, (Object)attributesValue);
        } else {
            MarshalledValue existingAttributesValue = (MarshalledValue)this.attributesCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)attributesKey, (Object)attributesValue);
            if (existingAttributesValue != null) {
                try {
                    attributes = (Map)this.marshaller.read((Object)existingAttributesValue);
                    attributesMutator = new CacheEntryMutator(this.attributesCache, (Object)attributesKey, (Object)existingAttributesValue);
                }
                catch (InvalidSerializedFormException e) {
                    InfinispanWebLogger.ROOT_LOGGER.failedToActivateSession(e, id);
                    this.remove(id);
                    return this.createValue(id, context);
                }
            }
        }
        return new CoarseSessionEntry((MutableCacheEntry<SessionCreationMetaData>)new MutableCacheEntry((Object)creationMetaDataEntry.getMetaData(), creationMetaDataMutator), (MutableCacheEntry<SessionAccessMetaData>)new MutableCacheEntry((Object)accessMetaData, accessMetaDataMutator), (MutableCacheEntry<Map<String, Object>>)new MutableCacheEntry(attributes, attributesMutator), creationMetaDataEntry.getLocalContext());
    }

    public CoarseSessionEntry<L> findValue(String id) {
        SessionCreationMetaDataKey creationMetaDataKey = new SessionCreationMetaDataKey(id);
        SessionCreationMetaDataEntry creationMetaDataEntry = (SessionCreationMetaDataEntry)this.findCreationMetaDataCache.get((Object)creationMetaDataKey);
        if (creationMetaDataEntry != null) {
            SessionAccessMetaDataKey accessMetaDataKey = new SessionAccessMetaDataKey(id);
            SessionAccessMetaData accessMetaData = (SessionAccessMetaData)this.accessMetaDataCache.get((Object)accessMetaDataKey);
            if (accessMetaData != null) {
                SessionAttributesKey attributesKey = new SessionAttributesKey(id);
                MarshalledValue attributesValue = (MarshalledValue)this.attributesCache.get((Object)attributesKey);
                if (attributesValue != null) {
                    try {
                        Map attributes = (Map)this.marshaller.read((Object)attributesValue);
                        CacheEntryMutator creationMetaDataMutator = new CacheEntryMutator(this.creationMetaDataCache, (Object)creationMetaDataKey, (Object)creationMetaDataEntry);
                        CacheEntryMutator accessMetaDataMutator = new CacheEntryMutator(this.accessMetaDataCache, (Object)accessMetaDataKey, (Object)accessMetaData);
                        CacheEntryMutator attributesMutator = new CacheEntryMutator(this.attributesCache, (Object)attributesKey, (Object)attributesValue);
                        return new CoarseSessionEntry((MutableCacheEntry<SessionCreationMetaData>)new MutableCacheEntry((Object)creationMetaDataEntry.getMetaData(), (Mutator)creationMetaDataMutator), (MutableCacheEntry<SessionAccessMetaData>)new MutableCacheEntry((Object)accessMetaData, (Mutator)accessMetaDataMutator), (MutableCacheEntry<Map<String, Object>>)new MutableCacheEntry((Object)attributes, (Mutator)attributesMutator), creationMetaDataEntry.getLocalContext());
                    }
                    catch (InvalidSerializedFormException e) {
                        InfinispanWebLogger.ROOT_LOGGER.failedToActivateSession(e, id);
                        this.remove(id);
                        return null;
                    }
                }
                this.accessMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)accessMetaDataKey);
            }
            this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES, Flag.SKIP_LISTENER_NOTIFICATION}).remove((Object)creationMetaDataKey);
        }
        return null;
    }

    public void remove(String id) {
        this.creationMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionCreationMetaDataKey(id));
        this.accessMetaDataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAccessMetaDataKey(id));
        this.attributesCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new SessionAttributesKey(id));
    }

    public void evict(String id) {
        try {
            this.creationMetaDataCache.evict((Object)new SessionCreationMetaDataKey(id));
            this.accessMetaDataCache.evict((Object)new SessionAccessMetaDataKey(id));
            this.attributesCache.evict((Object)new SessionAttributesKey(id));
        }
        catch (Throwable e) {
            InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSession(e, id);
        }
    }
}

