/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.memcached.MemcachedDecoder;
import org.infinispan.server.memcached.configuration.MemcachedServerConfiguration;
import org.infinispan.server.memcached.logging.JavaLog;
import org.infinispan.server.memcached.logging.Log;
import org.infinispan.server.memcached.logging.Log$class;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0001\u0002\u0001\u0017\tyQ*Z7dC\u000eDW\rZ*feZ,'O\u0003\u0002\u0004\t\u0005IQ.Z7dC\u000eDW\r\u001a\u0006\u0003\u000b\u0019\taa]3sm\u0016\u0014(BA\u0004\t\u0003)IgNZ5oSN\u0004\u0018M\u001c\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011\u0001B2pe\u0016L!!\u0005\b\u0003-\u0005\u00137\u000f\u001e:bGR\u0004&o\u001c;pG>d7+\u001a:wKJ\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0002\u0002\u000f1|wmZ5oO&\u0011q\u0003\u0006\u0002\u0004\u0019><\u0007\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u000b\u0011q\u0002\u0001A\u0010\u0003+M+\u0018\u000e^1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0011\u0001eI\u0007\u0002C)\u0011!EA\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\u0005\u0011\n#\u0001H'f[\u000e\f7\r[3e'\u0016\u0014h/\u001a:D_:4\u0017nZ;sCRLwN\u001c\u0005\tM\u0001A)\u0019!C\tO\u0005I1o\u00195fIVdWM]\u000b\u0002QA\u0011\u0011\u0006M\u0007\u0002U)\u00111\u0006L\u0001\u000bG>t7-\u001e:sK:$(BA\u0017/\u0003\u0011)H/\u001b7\u000b\u0003=\nAA[1wC&\u0011\u0011G\u000b\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007\u0002C\u001a\u0001\u0011\u0003\u0005\u000b\u0015\u0002\u0015\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0005C\u00056\u0001\u0001\u0007\t\u0019!C\u0005m\u0005qQ.Z7dC\u000eDW\rZ\"bG\",W#A\u001c\u0011\taJ4(R\u0007\u0002\r%\u0011!H\u0002\u0002\u000e\u0003\u00124\u0018M\\2fI\u000e\u000b7\r[3\u0011\u0005q\u0012eBA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s\u0014A\u0002)sK\u0012,g-\u0003\u0002D\t\n11\u000b\u001e:j]\u001eT!!\u0011 \u0011\u0007u2\u0005*\u0003\u0002H}\t)\u0011I\u001d:bsB\u0011Q(S\u0005\u0003\u0015z\u0012AAQ=uK\"IA\n\u0001a\u0001\u0002\u0004%I!T\u0001\u0013[\u0016l7-Y2iK\u0012\u001c\u0015m\u00195f?\u0012*\u0017\u000f\u0006\u0002O#B\u0011QhT\u0005\u0003!z\u0012A!\u00168ji\"9!kSA\u0001\u0002\u00049\u0014a\u0001=%c!1A\u000b\u0001Q!\n]\nq\"\\3nG\u0006\u001c\u0007.\u001a3DC\u000eDW\r\t\u0005\u0006-\u0002!\teV\u0001\u000egR\f'\u000f^%oi\u0016\u0014h.\u00197\u0015\u00079C\u0016\fC\u0003#+\u0002\u0007q\u0004C\u0003[+\u0002\u00071,\u0001\u0007dC\u000eDW-T1oC\u001e,'\u000f\u0005\u0002]?6\tQL\u0003\u0002_\r\u00059Q.\u00198bO\u0016\u0014\u0018B\u00011^\u0005Q)UNY3eI\u0016$7)Y2iK6\u000bg.Y4fe\")!\r\u0001C!G\u0006Qq-\u001a;F]\u000e|G-\u001a:\u0016\u0003\u0011\u0004\"!P3\n\u0005\u0019t$\u0001\u0002(vY2DQ\u0001\u001b\u0001\u0005B%\f!bZ3u\t\u0016\u001cw\u000eZ3s+\u0005Q\u0007C\u0001\u000fl\u0013\ta'A\u0001\tNK6\u001c\u0017m\u00195fI\u0012+7m\u001c3fe\")a\u000e\u0001C!_\u0006!1\u000f^8q+\u0005q\u0005")
public class MemcachedServer
extends AbstractProtocolServer
implements Log {
    private ScheduledExecutorService scheduler;
    private AdvancedCache<String, byte[]> memcachedCache;
    private final JavaLog log;
    private volatile byte bitmap$0;

    private ScheduledExecutorService scheduler$lzycompute() {
        MemcachedServer memcachedServer = this;
        synchronized (memcachedServer) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.scheduler = Executors.newScheduledThreadPool(1);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.scheduler;
        }
    }

    private JavaLog log$lzycompute() {
        MemcachedServer memcachedServer = this;
        synchronized (memcachedServer) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.log = Log$class.log(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.log;
        }
    }

    @Override
    public JavaLog log() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.log$lzycompute() : this.log;
    }

    public ScheduledExecutorService scheduler() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.scheduler$lzycompute() : this.scheduler;
    }

    private AdvancedCache<String, byte[]> memcachedCache() {
        return this.memcachedCache;
    }

    private void memcachedCache_$eq(AdvancedCache<String, byte[]> x$1) {
        this.memcachedCache = x$1;
    }

    public void startInternal(MemcachedServerConfiguration configuration, EmbeddedCacheManager cacheManager) {
        Object object = cacheManager.cacheExists(configuration.defaultCacheName()) ? BoxedUnit.UNIT : cacheManager.defineConfiguration(configuration.defaultCacheName(), new ConfigurationBuilder().read(cacheManager.getDefaultCacheConfiguration()).build());
        ExpirationConfiguration expConfig = cacheManager.getCacheConfiguration(configuration.defaultCacheName()).expiration();
        if (expConfig.lifespan() >= 0L || expConfig.maxIdle() >= 0L) {
            throw this.log().invalidExpiration(configuration.defaultCacheName());
        }
        this.memcachedCache_$eq((AdvancedCache<String, byte[]>)cacheManager.getCache(configuration.defaultCacheName()).getAdvancedCache());
        super.startInternal((ProtocolServerConfiguration)configuration, cacheManager);
    }

    public Null$ getEncoder() {
        return null;
    }

    public MemcachedDecoder getDecoder() {
        return new MemcachedDecoder(this.memcachedCache(), this.scheduler(), this.transport());
    }

    public void stop() {
        super.stop();
        this.scheduler().shutdown();
    }

    public MemcachedServer() {
        super("Memcached");
        Log$class.$init$(this);
    }
}

