/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientContextListener;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;

class RemotingCleanupHandler
implements EJBClientContextListener {
    private static final Logger logger = Logger.getLogger(RemotingCleanupHandler.class);
    private final List<Connection> connections = new ArrayList<Connection>();

    RemotingCleanupHandler() {
    }

    @Override
    public void contextClosed(EJBClientContext ejbClientContext) {
        this.closeAll();
    }

    @Override
    public void receiverRegistered(EJBReceiverContext receiverContext) {
    }

    @Override
    public void receiverUnRegistered(EJBReceiverContext receiverContext) {
    }

    void addConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        this.connections.add(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAll() {
        List<Connection> list = this.connections;
        synchronized (list) {
            for (Connection connection : this.connections) {
                this.safeClose((Closeable)connection);
            }
        }
    }

    private void safeClose(Closeable closable) {
        try {
            logger.debugf("Closing %s", (Object)closable);
            closable.close();
        }
        catch (Throwable e) {
            logger.debugf(e, "Exception closing %s", (Object)closable);
        }
    }
}

