/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.interpreter.statement;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.cli.interpreter.logging.Log;
import org.infinispan.cli.interpreter.result.EmptyResult;
import org.infinispan.cli.interpreter.result.Result;
import org.infinispan.cli.interpreter.result.StatementException;
import org.infinispan.cli.interpreter.result.StringResult;
import org.infinispan.cli.interpreter.session.Session;
import org.infinispan.cli.interpreter.statement.Option;
import org.infinispan.cli.interpreter.statement.SiteData;
import org.infinispan.cli.interpreter.statement.Statement;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteAdminOperations;

public class SiteStatement
implements Statement {
    private static final Log log = (Log)LogFactory.getLog(SiteStatement.class, Log.class);
    private final SiteData siteData;
    private final List<Option> options;

    public SiteStatement(List<Option> options, SiteData siteData) {
        this.options = options;
        this.siteData = siteData;
    }

    @Override
    public Result execute(Session session) throws StatementException {
        Cache cache = session.getCache(this.siteData != null ? this.siteData.getCacheName() : null);
        String siteName = this.siteData != null ? this.siteData.getSiteName() : null;
        XSiteAdminOperations xsiteAdmin = (XSiteAdminOperations)cache.getAdvancedCache().getComponentRegistry().getComponent(XSiteAdminOperations.class);
        if (xsiteAdmin == null) {
            throw log.noBackupsForCache(cache.getName());
        }
        for (Option opt : this.options) {
            switch (opt.toEnum(Options.class)) {
                case STATUS: {
                    String status = siteName == null ? xsiteAdmin.status() : xsiteAdmin.siteStatus(siteName);
                    return new StringResult(status);
                }
                case ONLINE: {
                    if (siteName != null) {
                        return new StringResult(xsiteAdmin.bringSiteOnline(siteName));
                    }
                    throw log.siteNameNotSpecified();
                }
                case OFFLINE: {
                    if (siteName != null) {
                        return new StringResult(xsiteAdmin.takeSiteOffline(siteName));
                    }
                    throw log.siteNameNotSpecified();
                }
                case PUSH: {
                    SiteStatement.requireSiteName(siteName);
                    return new StringResult(xsiteAdmin.pushState(siteName));
                }
                case CANCELPUSH: {
                    SiteStatement.requireSiteName(siteName);
                    return new StringResult(xsiteAdmin.cancelPushState(siteName));
                }
                case CANCELRECEIVE: {
                    SiteStatement.requireSiteName(siteName);
                    return new StringResult(xsiteAdmin.cancelReceiveState(siteName));
                }
                case PUSHSTATUS: {
                    return new StringResult(SiteStatement.prettyPrintMap(xsiteAdmin.getPushStateStatus()));
                }
                case CLEARPUSHSTATUS: {
                    return new StringResult(xsiteAdmin.clearPushStateStatus());
                }
                case SENDINGSITE: {
                    return new StringResult(xsiteAdmin.getSendingSiteName());
                }
            }
        }
        return EmptyResult.RESULT;
    }

    private static void requireSiteName(String siteName) throws StatementException {
        if (siteName == null) {
            throw log.siteNameNotSpecified();
        }
    }

    private static String prettyPrintMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> entry = iterator.next();
            builder.append(entry.getKey()).append("=").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    static enum Options {
        OFFLINE,
        ONLINE,
        STATUS,
        PUSH,
        CANCELPUSH,
        CANCELRECEIVE,
        PUSHSTATUS,
        CLEARPUSHSTATUS,
        SENDINGSITE;

    }
}

