/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.repository;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.ProtocolUtils;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.logging.BasicLogger;

public abstract class RemoteFileRequestAndHandler {
    private final RemoteFileProtocolIdMapper protocol;
    private final Executor asyncExecutor;

    protected RemoteFileRequestAndHandler(RemoteFileProtocolIdMapper protocol) {
        this(protocol, null);
    }

    protected RemoteFileRequestAndHandler(RemoteFileProtocolIdMapper protocol, Executor asyncExecutor) {
        this.protocol = protocol;
        this.asyncExecutor = asyncExecutor;
    }

    public void sendRequest(FlushableDataOutput output, byte rootId, String filePath) throws IOException {
        output.writeByte((int)this.protocol.paramRootId());
        output.writeByte((int)rootId);
        output.writeByte((int)this.protocol.paramFilePath());
        output.writeUTF(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleResponse(DataInput input, File localPath, BasicLogger log, ActiveOperation.ResultHandler<File> resultHandler, ManagementRequestContext<Void> context) throws IOException, CannotCreateLocalDirectoryException, DidNotReadEntireFileException {
        ProtocolUtils.expectHeader((DataInput)input, (int)this.protocol.paramNumFiles());
        int numFiles = input.readInt();
        log.debugf("Received %d files for %s", numFiles, (Object)localPath);
        switch (numFiles) {
            case -1: {
                break;
            }
            case 0: {
                if (localPath.mkdirs()) break;
                throw new CannotCreateLocalDirectoryException(localPath);
            }
            default: {
                for (int i = 0; i < numFiles; ++i) {
                    long totalRead;
                    ProtocolUtils.expectHeader((DataInput)input, (int)this.protocol.fileStart());
                    ProtocolUtils.expectHeader((DataInput)input, (int)this.protocol.paramFilePath());
                    String path = input.readUTF();
                    ProtocolUtils.expectHeader((DataInput)input, (int)this.protocol.paramFileSize());
                    long length = input.readLong();
                    log.debugf("Received file [%s] of length %d", (Object)path, (Object)length);
                    File file = new File(localPath, path);
                    if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                        throw new CannotCreateLocalDirectoryException(localPath.getParentFile());
                    }
                    try (OutputStream fileOut = null;){
                        int len;
                        fileOut = new BufferedOutputStream(new FileOutputStream(file));
                        byte[] buffer = new byte[8192];
                        for (totalRead = 0L; totalRead < length; totalRead += (long)len) {
                            len = Math.min((int)(length - totalRead), buffer.length);
                            input.readFully(buffer, 0, len);
                            fileOut.write(buffer, 0, len);
                        }
                    }
                    if (totalRead != length) {
                        throw new DidNotReadEntireFileException(length - totalRead);
                    }
                    ProtocolUtils.expectHeader((DataInput)input, (int)this.protocol.fileEnd());
                }
            }
        }
        resultHandler.done((Object)localPath);
    }

    public void handleRequest(DataInput input, final RootFileReader reader, ManagementRequestContext<Void> context) throws IOException {
        ProtocolUtils.expectHeader((DataInput)input, (int)this.protocol.paramRootId());
        final byte rootId = input.readByte();
        ProtocolUtils.expectHeader((DataInput)input, (int)this.protocol.paramFilePath());
        final String filePath = input.readUTF();
        ManagementRequestContext.AsyncTask<Void> task = new ManagementRequestContext.AsyncTask<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(ManagementRequestContext<Void> context) throws Exception {
                File localPath = reader.readRootFile(rootId, filePath);
                FlushableDataOutput output = context.writeMessage((ManagementProtocolHeader)ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader()));
                try {
                    RemoteFileRequestAndHandler.this.writeResponse(localPath, output);
                    output.close();
                }
                finally {
                    StreamUtils.safeClose((Closeable)output);
                }
            }
        };
        if (this.asyncExecutor == null) {
            context.executeAsync((ManagementRequestContext.AsyncTask)task);
        } else {
            context.executeAsync((ManagementRequestContext.AsyncTask)task, this.asyncExecutor);
        }
    }

    private void writeResponse(File localPath, FlushableDataOutput output) throws IOException {
        output.writeByte((int)this.protocol.paramNumFiles());
        if (localPath == null || !localPath.exists()) {
            output.writeInt(-1);
        } else if (localPath.isFile()) {
            output.writeInt(1);
            this.writeFile(localPath, localPath, output);
        } else {
            List<File> childFiles = this.getChildFiles(localPath);
            output.writeInt(childFiles.size());
            for (File child : childFiles) {
                this.writeFile(localPath, child, output);
            }
        }
    }

    private List<File> getChildFiles(File base) {
        ArrayList<File> childFiles = new ArrayList<File>();
        this.getChildFiles(base, childFiles);
        return childFiles;
    }

    private void getChildFiles(File base, List<File> childFiles) {
        for (File child : base.listFiles()) {
            if (child.isFile()) {
                childFiles.add(child);
                continue;
            }
            this.getChildFiles(child, childFiles);
        }
    }

    private String getRelativePath(File parent, File child) {
        return child.getAbsolutePath().substring(parent.getAbsolutePath().length() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(File localPath, File file, FlushableDataOutput output) throws IOException {
        output.writeByte((int)this.protocol.fileStart());
        output.writeByte((int)this.protocol.paramFilePath());
        output.writeUTF(this.getRelativePath(localPath, file));
        output.writeByte((int)this.protocol.paramFileSize());
        output.writeLong(file.length());
        FileInputStream inputStream = null;
        try {
            int len;
            inputStream = new FileInputStream(file);
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)inputStream).read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        output.writeByte((int)this.protocol.fileEnd());
    }

    public static class DidNotReadEntireFileException
    extends Exception {
        private static final long serialVersionUID = 1L;
        final long missing;

        private DidNotReadEntireFileException(long missing) {
            this.missing = missing;
        }

        public long getMissing() {
            return this.missing;
        }
    }

    public static class CannotCreateLocalDirectoryException
    extends Exception {
        private static final long serialVersionUID = 1L;
        final File dir;

        private CannotCreateLocalDirectoryException(File dir) {
            this.dir = dir;
        }

        public File getDir() {
            return this.dir;
        }
    }

    public static interface RootFileReader {
        public File readRootFile(byte var1, String var2) throws RequestProcessingException;
    }

    public static interface RemoteFileProtocolIdMapper {
        public byte paramRootId();

        public byte paramNumFiles();

        public byte fileStart();

        public byte paramFilePath();

        public byte paramFileSize();

        public byte fileEnd();
    }
}

