/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.spi.predicate;

import org.hibernate.hql.ast.spi.predicate.Predicate;
import org.hibernate.hql.internal.logging.Log;
import org.hibernate.hql.internal.logging.LoggerFactory;

public abstract class AbstractPredicate<Q>
implements Predicate<Q> {
    private static final Log log = LoggerFactory.make();
    private final Predicate.Type type;

    protected AbstractPredicate(Predicate.Type type) {
        this.type = type;
    }

    @Override
    public Predicate.Type getType() {
        return this.type;
    }

    @Override
    public <T extends Predicate<?>> T as(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)((Predicate)type.cast(this));
        }
        throw log.getUnsupportedPredicateTypeException(this, type.getCanonicalName());
    }
}

