/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint;

import java.io.Serializable;
import java.util.Arrays;
import org.infinispan.server.endpoint.EndpointLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StartException;

public class EndpointLogger_$logger
extends DelegatingBasicLogger
implements EndpointLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = EndpointLogger_$logger.class.getName();
    private static final String endpointStarting = "DGENDPT10000: %s starting";
    private static final String endpointStarted = "DGENDPT10001: %s listening on %s";
    private static final String httpEndpointStarted = "DGENDPT10002: %s mapped to %s/%s";
    private static final String noConnectorDefined = "DGENDPT10003: No connector is defined in the endpoint subsystem";
    private static final String failedStart = "DGENDPT10004: Failed to start %s";
    private static final String failedConnectorInstantiation = "DGENDPT10005: Failed to instantiate connector %s";
    private static final String failedTransportInstantiation = "DGENDPT10006: Failed to instantiate transport for connector %s";
    private static final String connectorStarting = "DGENDPT10007: Starting connector %s";
    private static final String connectorStopped = "DGENDPT10008: Stopped connector %s";
    private static final String connectorStopping = "DGENDPT10009: Stopping connector %s";
    private static final String connectorStopFailed = "DGENDPT10010: Failed to stop connector %s";
    private static final String failedToDetermineServlet = "DGENDPT10011: Failed to determine servlet";
    private static final String contextStopFailed = "DGENDPT10012: Could not stop context";
    private static final String contextDestroyFailed = "DGENDPT10013: Could not destroy context";
    private static final String restCacheManagerInjectionFailed = "DGENDPT10014: Could not set the CacheManager on the REST Server";
    private static final String restContextCreationFailed = "DGENDPT10015: Could not create the web context for the REST Server";
    private static final String restContextStartFailed = "DGENDPT10016: Could not start the web context for the REST Server";
    private static final String cannotLocateServerBootstrap = "DGENDPT10017: Failed to locate ServerBootstrap";
    private static final String noSSLContext = "DGENDPT10018: Endpoint '%s' requires SSL, but no SSL context is available in realm '%s'";
    private static final String topologyUpdateTimeoutIgnored = "DGENDPT10019: The topology update timeout configuration is ignored";
    private static final String invalidQOPV = "DGENDPT10020: Invalid QOP value: %s";
    private static final String invalidStrength = "DGENDPT10021: Invalid Strength value: %s";
    private static final String cannotRetrieveAuthorizationInformation = "DGENDPT10022: Cannot retrieve authorization information for user %s";
    private static final String noSSLTrustStore = "DGENDPT10023: Endpoint '%s' requires Client Certificates, but no Trust Store is available in realm '%s'";
    private static final String invalidAuthorizationId = "DGENDPT10024: Invalid authorizationId %s";
    private static final String cannotInstantiateClass = "DGENDPT10025: Unable to instantiate class \"%s\": %s";
    private static final String noFactoryName = "DGENDPT10026: No @NamedFactory annotation found in class: %s";
    private static final String serviceNotStarted = "DGENDPT10027: Service not started";
    private static final String nullVar = "DGENDPT10028: %s is null";
    private static final String duplicateMarshallerDeployment = "DGENDPT10029: Ignoring duplicate marshaller deployment found in %s. A marshaller has already been installed";
    private static final String virtualHostNotInUse = "DGENDPT10030: virtual-host attribute not in use";

    public EndpointLogger_$logger(Logger log) {
        super(log);
    }

    @Override
    public final void endpointStarting(String protocolName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.endpointStarting$str(), (Object)protocolName);
    }

    protected String endpointStarting$str() {
        return endpointStarting;
    }

    @Override
    public final void endpointStarted(String protocolName, String listenAddress) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.endpointStarted$str(), (Object)protocolName, (Object)listenAddress);
    }

    protected String endpointStarted$str() {
        return endpointStarted;
    }

    @Override
    public final void httpEndpointStarted(String protocolName, String contextPath, String servletPath) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.httpEndpointStarted$str(), (Object)protocolName, (Object)contextPath, (Object)servletPath);
    }

    protected String httpEndpointStarted$str() {
        return httpEndpointStarted;
    }

    protected String noConnectorDefined$str() {
        return noConnectorDefined;
    }

    @Override
    public final StartException noConnectorDefined() {
        StartException result = new StartException(String.format(this.noConnectorDefined$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedStart$str() {
        return failedStart;
    }

    @Override
    public final StartException failedStart(Throwable t, String serverName) {
        StartException result = new StartException(String.format(this.failedStart$str(), serverName), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedConnectorInstantiation$str() {
        return failedConnectorInstantiation;
    }

    @Override
    public final StartException failedConnectorInstantiation(Throwable cause, String connectorName) {
        StartException result = new StartException(String.format(this.failedConnectorInstantiation$str(), connectorName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failedTransportInstantiation$str() {
        return failedTransportInstantiation;
    }

    @Override
    public final StartException failedTransportInstantiation(Throwable cause, String connectorName) {
        StartException result = new StartException(String.format(this.failedTransportInstantiation$str(), connectorName), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void connectorStarting(String serverName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.connectorStarting$str(), (Object)serverName);
    }

    protected String connectorStarting$str() {
        return connectorStarting;
    }

    @Override
    public final void connectorStopped(String serverName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.connectorStopped$str(), (Object)serverName);
    }

    protected String connectorStopped$str() {
        return connectorStopped;
    }

    @Override
    public final void connectorStopping(String serverName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.connectorStopping$str(), (Object)serverName);
    }

    protected String connectorStopping$str() {
        return connectorStopping;
    }

    @Override
    public final void connectorStopFailed(Throwable cause, String serverName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.connectorStopFailed$str(), (Object)serverName);
    }

    protected String connectorStopFailed$str() {
        return connectorStopFailed;
    }

    @Override
    public final void failedToDetermineServlet(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.INFO, cause, this.failedToDetermineServlet$str(), new Object[0]);
    }

    protected String failedToDetermineServlet$str() {
        return failedToDetermineServlet;
    }

    @Override
    public final void contextStopFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.contextStopFailed$str(), new Object[0]);
    }

    protected String contextStopFailed$str() {
        return contextStopFailed;
    }

    @Override
    public final void contextDestroyFailed(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.contextDestroyFailed$str(), new Object[0]);
    }

    protected String contextDestroyFailed$str() {
        return contextDestroyFailed;
    }

    protected String restCacheManagerInjectionFailed$str() {
        return restCacheManagerInjectionFailed;
    }

    @Override
    public final StartException restCacheManagerInjectionFailed(Throwable cause) {
        StartException result = new StartException(String.format(this.restCacheManagerInjectionFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String restContextCreationFailed$str() {
        return restContextCreationFailed;
    }

    @Override
    public final StartException restContextCreationFailed(Throwable cause) {
        StartException result = new StartException(String.format(this.restContextCreationFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String restContextStartFailed$str() {
        return restContextStartFailed;
    }

    @Override
    public final StartException restContextStartFailed(Throwable cause) {
        StartException result = new StartException(String.format(this.restContextStartFailed$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotLocateServerBootstrap$str() {
        return cannotLocateServerBootstrap;
    }

    @Override
    public final ServiceRegistryException cannotLocateServerBootstrap(Throwable t) {
        ServiceRegistryException result = new ServiceRegistryException(String.format(this.cannotLocateServerBootstrap$str(), new Object[0]), t);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSSLContext$str() {
        return noSSLContext;
    }

    @Override
    public final StartException noSSLContext(String endpoint, String realm) {
        StartException result = new StartException(String.format(this.noSSLContext$str(), endpoint, realm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void topologyUpdateTimeoutIgnored() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.topologyUpdateTimeoutIgnored$str(), new Object[0]);
    }

    protected String topologyUpdateTimeoutIgnored$str() {
        return topologyUpdateTimeoutIgnored;
    }

    protected String invalidQOPV$str() {
        return invalidQOPV;
    }

    @Override
    public final IllegalStateException invalidQOPV(String qop) {
        IllegalStateException result = new IllegalStateException(String.format(this.invalidQOPV$str(), qop));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidStrength$str() {
        return invalidStrength;
    }

    @Override
    public final IllegalStateException invalidStrength(String strengthValue) {
        IllegalStateException result = new IllegalStateException(String.format(this.invalidStrength$str(), strengthValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotRetrieveAuthorizationInformation$str() {
        return cannotRetrieveAuthorizationInformation;
    }

    @Override
    public final SecurityException cannotRetrieveAuthorizationInformation(Throwable cause, String user) {
        SecurityException result = new SecurityException(String.format(this.cannotRetrieveAuthorizationInformation$str(), user), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSSLTrustStore$str() {
        return noSSLTrustStore;
    }

    @Override
    public final StartException noSSLTrustStore(String endpoint, String realm) {
        StartException result = new StartException(String.format(this.noSSLTrustStore$str(), endpoint, realm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidAuthorizationId$str() {
        return invalidAuthorizationId;
    }

    @Override
    public final IllegalArgumentException invalidAuthorizationId(String authorizationId) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.invalidAuthorizationId$str(), authorizationId));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void cannotInstantiateClass(String clazz, Throwable reason) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cannotInstantiateClass$str(), (Object)clazz, (Object)reason);
    }

    protected String cannotInstantiateClass$str() {
        return cannotInstantiateClass;
    }

    @Override
    public final void noFactoryName(String clazz) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.noFactoryName$str(), (Object)clazz);
    }

    protected String noFactoryName$str() {
        return noFactoryName;
    }

    protected String serviceNotStarted$str() {
        return serviceNotStarted;
    }

    @Override
    public final IllegalStateException serviceNotStarted() {
        IllegalStateException result = new IllegalStateException(String.format(this.serviceNotStarted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullVar$str() {
        return nullVar;
    }

    @Override
    public final String nullVar(String name) {
        return String.format(this.nullVar$str(), name);
    }

    @Override
    public final void duplicateMarshallerDeployment(String deploymentName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.duplicateMarshallerDeployment$str(), (Object)deploymentName);
    }

    protected String duplicateMarshallerDeployment$str() {
        return duplicateMarshallerDeployment;
    }

    @Override
    public final void virtualHostNotInUse() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.virtualHostNotInUse$str(), new Object[0]);
    }

    protected String virtualHostNotInUse$str() {
        return virtualHostNotInUse;
    }
}

