/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.scripting.impl.CacheScriptBindings;
import org.infinispan.scripting.impl.CollatorScript;
import org.infinispan.scripting.impl.MapperScript;
import org.infinispan.scripting.impl.ReducerScript;
import org.infinispan.scripting.impl.ScriptMetadata;
import org.infinispan.scripting.impl.ScriptRunner;
import org.infinispan.scripting.impl.ScriptingManagerImpl;
import org.infinispan.scripting.impl.SystemBindings;

public class MapReduceRunner
implements ScriptRunner {
    public static final MapReduceRunner INSTANCE = new MapReduceRunner();

    private MapReduceRunner() {
    }

    @Override
    public <T> NotifyingFuture<T> runScript(ScriptingManagerImpl scriptManager, ScriptMetadata metadata, CacheScriptBindings binding) {
        String collatorScript;
        String combinerScript;
        MapReduceTask mapReduceTask = new MapReduceTask((Cache)binding.get(SystemBindings.CACHE.toString()));
        mapReduceTask.mappedWith(new MapperScript(metadata));
        String reducerScript = metadata.property(ScriptMetadata.MetadataProperties.REDUCER);
        if (reducerScript != null) {
            mapReduceTask.reducedWith(new ReducerScript(scriptManager.getScriptMetadata(reducerScript)));
        }
        if ((combinerScript = metadata.property(ScriptMetadata.MetadataProperties.COMBINER)) != null) {
            mapReduceTask.combinedWith(new ReducerScript(scriptManager.getScriptMetadata(combinerScript)));
        }
        if ((collatorScript = metadata.property(ScriptMetadata.MetadataProperties.COLLATOR)) != null) {
            return (NotifyingFuture)mapReduceTask.executeAsynchronously(new CollatorScript(scriptManager.getScriptMetadata(collatorScript), scriptManager));
        }
        return (NotifyingFuture)mapReduceTask.executeAsynchronously();
    }
}

