/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.aggregation;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;

public final class Grouper {
    private final int[] groupFieldPositions;
    private final FieldAccumulator[] accumulators;
    private final int rowLength;
    private final LinkedHashMap<GroupRowKey, Object[]> groups;
    private Object[] globalGroup;

    public Grouper(int[] groupFieldPositions, FieldAccumulator[] accumulators) {
        this.groupFieldPositions = groupFieldPositions != null && groupFieldPositions.length != 0 ? groupFieldPositions : null;
        this.accumulators = accumulators != null && accumulators.length != 0 ? accumulators : null;
        this.rowLength = (groupFieldPositions != null ? groupFieldPositions.length : 0) + (accumulators != null ? accumulators.length : 0);
        if (this.rowLength == 0) {
            throw new IllegalArgumentException("Must have at least one grouping or aggregated column");
        }
        this.groups = this.groupFieldPositions != null ? new LinkedHashMap() : null;
    }

    public void addRow(Object[] row) {
        block10: {
            block8: {
                Object[] existingGroup;
                block9: {
                    if (row.length != this.rowLength) {
                        throw new IllegalArgumentException("Row length mismatch");
                    }
                    if (this.groupFieldPositions == null) break block8;
                    GroupRowKey groupRowKey = new GroupRowKey(row, this.groupFieldPositions);
                    existingGroup = this.groups.get(groupRowKey);
                    if (existingGroup != null) break block9;
                    if (this.accumulators != null) {
                        for (FieldAccumulator acc : this.accumulators) {
                            acc.init(row);
                        }
                    }
                    this.groups.put(groupRowKey, row);
                    break block10;
                }
                if (this.accumulators == null) break block10;
                for (FieldAccumulator acc : this.accumulators) {
                    acc.update(row, existingGroup);
                }
                break block10;
            }
            if (this.globalGroup == null) {
                this.globalGroup = row;
                for (FieldAccumulator acc : this.accumulators) {
                    acc.init(row);
                }
            } else {
                for (FieldAccumulator acc : this.accumulators) {
                    acc.update(row, this.globalGroup);
                }
            }
        }
    }

    public Iterator<Object[]> finish() {
        if (this.groups != null) {
            return new Iterator<Object[]>(){
                private final Iterator<Object[]> iterator;
                {
                    this.iterator = Grouper.this.groups.values().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.iterator.hasNext();
                }

                @Override
                public Object[] next() {
                    Object[] row = this.iterator.next();
                    if (Grouper.this.accumulators != null) {
                        for (FieldAccumulator acc : Grouper.this.accumulators) {
                            acc.finish(row);
                        }
                    }
                    return row;
                }
            };
        }
        for (FieldAccumulator acc : this.accumulators) {
            acc.finish(this.globalGroup);
        }
        return Collections.singleton(this.globalGroup).iterator();
    }

    public String toString() {
        return "Grouper{groupFieldPositions=" + Arrays.toString(this.groupFieldPositions) + ", accumulators=" + Arrays.toString(this.accumulators) + ", number of groups=" + this.groups.size() + '}';
    }

    private final class GroupRowKey {
        private final Object[] row;
        private final int[] groupFieldPositions;

        GroupRowKey(Object[] row, int[] groupFieldPositions) {
            this.row = row;
            this.groupFieldPositions = groupFieldPositions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupRowKey other = (GroupRowKey)o;
            for (int pos : this.groupFieldPositions) {
                Object o1 = this.row[pos];
                Object o2 = other.row[pos];
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 1;
            for (int pos : this.groupFieldPositions) {
                Object e = this.row[pos];
                result = 31 * result + (e == null ? 0 : e.hashCode());
            }
            return result;
        }
    }
}

