/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.aggregation;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.infinispan.objectfilter.impl.aggregation.DoubleSum;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;

public final class SumAccumulator
extends FieldAccumulator {
    private final Class<? extends Number> fieldType;

    public SumAccumulator(int pos, Class<?> fieldType) {
        super(pos);
        if (!Number.class.isAssignableFrom(fieldType)) {
            throw new IllegalStateException("Aggregation SUM cannot be applied to property of type " + fieldType.getName());
        }
        this.fieldType = fieldType;
    }

    @Override
    public void init(Object[] accRow) {
        Number value = (Number)accRow[this.pos];
        if (value != null) {
            if (this.fieldType == Integer.class || this.fieldType == Byte.class || this.fieldType == Short.class) {
                accRow[this.pos] = value.longValue();
            } else if (this.fieldType == Double.class || this.fieldType == Float.class) {
                DoubleSum doubleSum = new DoubleSum();
                accRow[this.pos] = doubleSum;
                doubleSum.update(value.doubleValue());
            } else {
                accRow[this.pos] = value;
            }
        }
    }

    @Override
    public void update(Object[] srcRow, Object[] accRow) {
        Number value = (Number)srcRow[this.pos];
        if (value != null) {
            Number sum;
            if (this.fieldType == Double.class || this.fieldType == Float.class) {
                DoubleSum doubleSum = (DoubleSum)accRow[this.pos];
                if (doubleSum == null) {
                    doubleSum = new DoubleSum();
                    accRow[this.pos] = doubleSum;
                }
                doubleSum.update(value.doubleValue());
                return;
            }
            if (this.fieldType == Integer.class || this.fieldType == Byte.class || this.fieldType == Short.class) {
                value = value.longValue();
            }
            if ((sum = (Number)accRow[this.pos]) != null) {
                value = this.fieldType == Long.class ? (Number)(sum.longValue() + value.longValue()) : (Number)(this.fieldType == BigInteger.class ? ((BigInteger)sum).add((BigInteger)value) : (this.fieldType == BigDecimal.class ? ((BigDecimal)sum).add((BigDecimal)value) : Integer.valueOf(sum.intValue() + value.intValue())));
            }
            accRow[this.pos] = value;
        }
    }

    @Override
    public void finish(Object[] accRow) {
        if (this.fieldType == Double.class || this.fieldType == Float.class) {
            accRow[this.pos] = ((DoubleSum)accRow[this.pos]).getValue();
        }
    }
}

