/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PredicateOptimisations;
import org.infinispan.objectfilter.impl.syntax.PrimaryPredicateExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;

public final class BooleShannonExpansion {
    private final int maxExpansionCofactors;
    private final IndexedFieldProvider indexedFieldProvider;

    public BooleShannonExpansion(int maxExpansionCofactors, IndexedFieldProvider indexedFieldProvider) {
        this.maxExpansionCofactors = maxExpansionCofactors;
        this.indexedFieldProvider = indexedFieldProvider;
    }

    public BooleanExpr expand(BooleanExpr booleanExpr) {
        if (booleanExpr instanceof ConstantBooleanExpr) {
            return booleanExpr;
        }
        Collector collector = new Collector(this.indexedFieldProvider);
        booleanExpr.acceptVisitor(collector);
        if (!collector.foundIndexed) {
            return ConstantBooleanExpr.TRUE;
        }
        if (!collector.predicatesToRemove.isEmpty()) {
            int numCofactors = 1;
            for (PrimaryPredicateExpr e : collector.predicatesToRemove) {
                Replacer replacer1 = new Replacer(e, ConstantBooleanExpr.TRUE);
                BooleanExpr e1 = (BooleanExpr)booleanExpr.acceptVisitor(replacer1);
                if (!replacer1.found) continue;
                if (e1 == ConstantBooleanExpr.TRUE) {
                    return ConstantBooleanExpr.TRUE;
                }
                Replacer replacer2 = new Replacer(e, ConstantBooleanExpr.FALSE);
                BooleanExpr e2 = (BooleanExpr)booleanExpr.acceptVisitor(replacer2);
                if (e2 == ConstantBooleanExpr.TRUE) {
                    return ConstantBooleanExpr.TRUE;
                }
                if (e1 == ConstantBooleanExpr.FALSE) {
                    booleanExpr = e2;
                } else if (e2 == ConstantBooleanExpr.FALSE) {
                    booleanExpr = e1;
                } else {
                    OrExpr disjunction;
                    numCofactors *= 2;
                    if (e1 instanceof OrExpr) {
                        disjunction = (OrExpr)e1;
                        if (e2 instanceof OrExpr) {
                            disjunction.getChildren().addAll(((OrExpr)e2).getChildren());
                        } else {
                            disjunction.getChildren().add(e2);
                        }
                    } else if (e2 instanceof OrExpr) {
                        disjunction = (OrExpr)e2;
                        disjunction.getChildren().add(e1);
                    } else {
                        disjunction = new OrExpr(e1, e2);
                    }
                    PredicateOptimisations.optimizePredicates(disjunction.getChildren(), false);
                    booleanExpr = disjunction;
                }
                if (numCofactors <= this.maxExpansionCofactors) continue;
                return ConstantBooleanExpr.TRUE;
            }
        }
        return booleanExpr;
    }

    private static class Replacer
    implements Visitor {
        private final PrimaryPredicateExpr toReplace;
        private final ConstantBooleanExpr with;
        private boolean found = false;

        private Replacer(PrimaryPredicateExpr toReplace, ConstantBooleanExpr with) {
            this.toReplace = toReplace;
            this.with = with;
        }

        @Override
        public BooleanExpr visit(NotExpr notExpr) {
            BooleanExpr transformedChild = (BooleanExpr)notExpr.getChild().acceptVisitor(this);
            if (transformedChild instanceof ConstantBooleanExpr) {
                return ((ConstantBooleanExpr)transformedChild).negate();
            }
            return new NotExpr(transformedChild);
        }

        @Override
        public BooleanExpr visit(OrExpr orExpr) {
            ArrayList<BooleanExpr> newChildren = new ArrayList<BooleanExpr>(orExpr.getChildren().size());
            for (BooleanExpr c : orExpr.getChildren()) {
                BooleanExpr e = (BooleanExpr)c.acceptVisitor(this);
                if (e instanceof ConstantBooleanExpr) {
                    if (!((ConstantBooleanExpr)e).getValue()) continue;
                    return ConstantBooleanExpr.TRUE;
                }
                if (e instanceof OrExpr) {
                    newChildren.addAll(((OrExpr)e).getChildren());
                    continue;
                }
                newChildren.add(e);
            }
            PredicateOptimisations.optimizePredicates(newChildren, false);
            if (newChildren.size() == 1) {
                return (BooleanExpr)newChildren.get(0);
            }
            return new OrExpr(newChildren);
        }

        @Override
        public BooleanExpr visit(AndExpr andExpr) {
            ArrayList<BooleanExpr> newChildren = new ArrayList<BooleanExpr>(andExpr.getChildren().size());
            for (BooleanExpr c : andExpr.getChildren()) {
                BooleanExpr e = (BooleanExpr)c.acceptVisitor(this);
                if (e instanceof ConstantBooleanExpr) {
                    if (((ConstantBooleanExpr)e).getValue()) continue;
                    return ConstantBooleanExpr.FALSE;
                }
                if (e instanceof AndExpr) {
                    newChildren.addAll(((AndExpr)e).getChildren());
                    continue;
                }
                newChildren.add(e);
            }
            PredicateOptimisations.optimizePredicates(newChildren, true);
            if (newChildren.size() == 1) {
                return (BooleanExpr)newChildren.get(0);
            }
            return new AndExpr(newChildren);
        }

        @Override
        public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
            return constantBooleanExpr;
        }

        @Override
        public BooleanExpr visit(IsNullExpr isNullExpr) {
            return this.replacePredicate(isNullExpr);
        }

        @Override
        public BooleanExpr visit(ComparisonExpr comparisonExpr) {
            return this.replacePredicate(comparisonExpr);
        }

        @Override
        public BooleanExpr visit(LikeExpr likeExpr) {
            return this.replacePredicate(likeExpr);
        }

        @Override
        public ValueExpr visit(ConstantValueExpr constantValueExpr) {
            return constantValueExpr;
        }

        @Override
        public ValueExpr visit(PropertyValueExpr propertyValueExpr) {
            return propertyValueExpr;
        }

        @Override
        public ValueExpr visit(AggregationExpr aggregationExpr) {
            return aggregationExpr;
        }

        private BooleanExpr replacePredicate(PrimaryPredicateExpr primaryPredicateExpr) {
            switch (PredicateOptimisations.comparePrimaryPredicates(false, primaryPredicateExpr, false, this.toReplace)) {
                case 0: {
                    this.found = true;
                    return this.with;
                }
                case 1: {
                    this.found = true;
                    return this.with.negate();
                }
            }
            return primaryPredicateExpr;
        }
    }

    private static class Collector
    implements Visitor {
        private final IndexedFieldProvider indexedFieldProvider;
        private boolean foundIndexed = false;
        private final Set<PrimaryPredicateExpr> predicatesToRemove = new LinkedHashSet<PrimaryPredicateExpr>();

        private Collector(IndexedFieldProvider indexedFieldProvider) {
            this.indexedFieldProvider = indexedFieldProvider;
        }

        @Override
        public BooleanExpr visit(NotExpr notExpr) {
            notExpr.getChild().acceptVisitor(this);
            return notExpr;
        }

        @Override
        public BooleanExpr visit(OrExpr orExpr) {
            for (BooleanExpr c : orExpr.getChildren()) {
                c.acceptVisitor(this);
            }
            return orExpr;
        }

        @Override
        public BooleanExpr visit(AndExpr andExpr) {
            for (BooleanExpr c : andExpr.getChildren()) {
                c.acceptVisitor(this);
            }
            return andExpr;
        }

        @Override
        public BooleanExpr visit(ConstantBooleanExpr constantBooleanExpr) {
            return constantBooleanExpr;
        }

        @Override
        public BooleanExpr visit(IsNullExpr isNullExpr) {
            PropertyValueExpr propertyValueExpr = (PropertyValueExpr)isNullExpr.getChild();
            if (this.indexedFieldProvider.isIndexed(propertyValueExpr.getPropertyPath())) {
                this.foundIndexed = true;
            } else {
                this.predicatesToRemove.add(isNullExpr);
            }
            return isNullExpr;
        }

        @Override
        public BooleanExpr visit(ComparisonExpr comparisonExpr) {
            PropertyValueExpr propertyValueExpr = (PropertyValueExpr)comparisonExpr.getLeftChild();
            if (this.indexedFieldProvider.isIndexed(propertyValueExpr.getPropertyPath())) {
                this.foundIndexed = true;
            } else {
                this.predicatesToRemove.add(comparisonExpr);
            }
            return comparisonExpr;
        }

        @Override
        public BooleanExpr visit(LikeExpr likeExpr) {
            PropertyValueExpr propertyValueExpr = (PropertyValueExpr)likeExpr.getChild();
            if (this.indexedFieldProvider.isIndexed(propertyValueExpr.getPropertyPath())) {
                this.foundIndexed = true;
            } else {
                this.predicatesToRemove.add(likeExpr);
            }
            return likeExpr;
        }

        @Override
        public ValueExpr visit(ConstantValueExpr constantValueExpr) {
            return constantValueExpr;
        }

        @Override
        public ValueExpr visit(PropertyValueExpr propertyValueExpr) {
            return propertyValueExpr;
        }

        @Override
        public ValueExpr visit(AggregationExpr aggregationExpr) {
            return aggregationExpr;
        }
    }

    public static interface IndexedFieldProvider {
        public boolean isIndexed(List<String> var1);
    }
}

