/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.security.jaspi;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.AttachmentKey;
import java.security.Principal;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.MessageInfo;
import org.jboss.security.auth.callback.JASPICallbackHandler;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.message.GenericMessageInfo;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleRole;
import org.jboss.security.identity.plugins.SimpleRoleGroup;
import org.jboss.security.plugins.auth.JASPIServerAuthenticationManager;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.extension.undertow.security.AccountImpl;
import org.wildfly.extension.undertow.security.jaspi.JASPICAttachment;
import org.wildfly.extension.undertow.security.jaspi.SecurityActions;

public class JASPIAuthenticationMechanism
implements AuthenticationMechanism {
    private static final String JASPI_HTTP_SERVLET_LAYER = "HttpServlet";
    private static final String MECHANISM_NAME = "JASPIC";
    private static final String JASPI_AUTH_TYPE = "javax.servlet.http.authType";
    private static final String JASPI_REGISTER_SESSION = "javax.servlet.http.registerSession";
    public static final AttachmentKey<HttpServerExchange> HTTP_SERVER_EXCHANGE_ATTACHMENT_KEY = AttachmentKey.create(HttpServerExchange.class);
    public static final AttachmentKey<SecurityContext> SECURITY_CONTEXT_ATTACHMENT_KEY = AttachmentKey.create(SecurityContext.class);
    private final String configuredAuthMethod;
    private final String securityDomain;

    public JASPIAuthenticationMechanism(String configuredAuthMethod, String securityDomain) {
        this.configuredAuthMethod = configuredAuthMethod;
        this.securityDomain = securityDomain;
    }

    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext sc) {
        AuthenticationMechanism.AuthenticationMechanismOutcome outcome;
        String authType;
        JASPICAttachment attachment = (JASPICAttachment)exchange.getAttachment(JASPICAttachment.ATTACHMENT_KEY);
        Account authenticatedAccount = null;
        Boolean isValid = attachment.getValid();
        attachment.setValid(null);
        GenericMessageInfo messageInfo = attachment.getMessageInfo();
        if (isValid == null) {
            isValid = this.createJASPIAuthenticationManager().isValid((MessageInfo)messageInfo, new Subject(), JASPI_HTTP_SERVLET_LAYER, attachment.getApplicationIdentifier(), (CallbackHandler)new JBossCallbackHandler());
        }
        ServletRequestContext requestContext = attachment.getRequestContext();
        JASPIServerAuthenticationManager sam = attachment.getSam();
        JASPICallbackHandler cbh = attachment.getCbh();
        if (isValid.booleanValue()) {
            org.jboss.security.SecurityContext jbossSct = SecurityActions.getSecurityContext();
            authenticatedAccount = this.createAccount(attachment.getCachedAccount(), jbossSct);
        }
        if ((authType = (String)messageInfo.getMap().get(JASPI_AUTH_TYPE)) == null) {
            String string = authType = this.configuredAuthMethod != null ? this.configuredAuthMethod : MECHANISM_NAME;
        }
        if (isValid.booleanValue() && authenticatedAccount != null) {
            outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
            Object registerObj = messageInfo.getMap().get(JASPI_REGISTER_SESSION);
            boolean cache = false;
            if (registerObj != null && registerObj instanceof String) {
                cache = Boolean.valueOf((String)registerObj);
            }
            sc.authenticationComplete(authenticatedAccount, authType, cache);
        } else if (isValid.booleanValue() && authenticatedAccount == null && !this.isMandatory(requestContext).booleanValue()) {
            outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
        } else {
            outcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_AUTHENTICATED;
            sc.authenticationFailed("JASPIC authentication failed.", authType);
        }
        return outcome;
    }

    private JASPIServerAuthenticationManager createJASPIAuthenticationManager() {
        return new JASPIServerAuthenticationManager(this.securityDomain, (CallbackHandler)new JBossCallbackHandler());
    }

    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(true);
    }

    private Account createAccount(Account cachedAccount, org.jboss.security.SecurityContext jbossSct) {
        if (jbossSct == null) {
            throw UndertowLogger.ROOT_LOGGER.nullParamter("org.jboss.security.SecurityContext");
        }
        Principal userPrincipal = jbossSct.getUtil().getUserPrincipal();
        if (userPrincipal == null) {
            return null;
        }
        if (cachedAccount != null && cachedAccount.getPrincipal() == userPrincipal) {
            jbossSct.getUtil().createSubjectInfo(userPrincipal, ((AccountImpl)cachedAccount).getCredential(), null);
            SimpleRoleGroup roleGroup = new SimpleRoleGroup("Roles");
            for (String role : cachedAccount.getRoles()) {
                roleGroup.addRole((Role)new SimpleRole(role));
            }
            jbossSct.getUtil().setRoles((RoleGroup)roleGroup);
            return cachedAccount;
        }
        HashSet<String> stringRoles = new HashSet<String>();
        RoleGroup roleGroup = jbossSct.getUtil().getRoles();
        if (roleGroup != null) {
            for (Role role : roleGroup.getRoles()) {
                stringRoles.add(role.getRoleName());
            }
        }
        Object credential = jbossSct.getUtil().getCredential();
        Principal original = null;
        if (cachedAccount != null) {
            original = cachedAccount.getPrincipal();
        }
        return new AccountImpl(userPrincipal, stringRoles, credential, original);
    }

    private Boolean isMandatory(ServletRequestContext attachment) {
        return attachment.getExchange().getSecurityContext() != null && attachment.getExchange().getSecurityContext().isAuthenticationRequired();
    }
}

