/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.impl.RemovableCloseableIterator;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;

public class LocalKeyCacheStream<K, V>
extends AbstractLocalCacheStream<K, K, V> {
    private final Cache<K, V> cache;

    public LocalKeyCacheStream(Cache<K, V> cache, boolean parallel, ConsistentHash hash, Supplier<Stream<CacheEntry<K, V>>> supplier, ComponentRegistry registry) {
        super(parallel, hash, supplier, registry);
        this.cache = cache;
    }

    @Override
    protected Stream<K> getStream() {
        Stream<Object> stream;
        if (this.keysToFilter != null) {
            this.log.tracef("Applying key filtering %s", this.keysToFilter);
            stream = this.keysToFilter.stream().filter((? super T k) -> this.cache.containsKey(k));
        } else {
            stream = ((Stream)this.supplier.get()).map((? super T e) -> e.getKey());
        }
        if (this.segmentsToFilter != null && this.hash != null) {
            this.log.tracef("Applying segment filter %s", this.segmentsToFilter);
            stream = stream.filter((? super T k) -> this.segmentsToFilter.contains(this.hash.getSegment(k)));
        }
        return stream;
    }

    @Override
    protected CloseableIterator<K> removableIterator(CloseableIterator<K> realIterator) {
        return new RemovableCloseableIterator<K, K>(realIterator, this.cache, Function.identity());
    }
}

