/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop.primitive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.BaseTerminalOperation;

public class ForEachLongOperation<K>
extends BaseTerminalOperation
implements KeyTrackingTerminalOperation<K, Long, K> {
    private final int batchSize;
    private final LongConsumer consumer;

    public ForEachLongOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<CacheEntry>> supplier, int batchSize, LongConsumer consumer) {
        super(intermediateOperations, supplier);
        this.batchSize = batchSize;
        this.consumer = consumer;
    }

    @Override
    public boolean lostSegment(boolean stopIfLost) {
        return true;
    }

    @Override
    public List<Long> performOperation(KeyTrackingTerminalOperation.IntermediateCollector<Collection<Long>> response) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<CacheEntry<K, K>> performOperationRehashAware(KeyTrackingTerminalOperation.IntermediateCollector<Collection<CacheEntry<K, K>>> response) {
        Object stream = ((BaseStream)this.supplier.get()).sequential();
        ArrayList<CacheEntry<K, K>> collectedValues = new ArrayList<CacheEntry<K, K>>(this.batchSize);
        long[] list = new long[this.batchSize];
        AtomicInteger offset = new AtomicInteger();
        Object[] currentKey = new Object[1];
        stream = ((Stream)stream).peek(e -> {
            if (offset.get() > 0) {
                collectedValues.add(new ImmortalCacheEntry(currentKey[0], currentKey[0]));
                if (collectedValues.size() >= this.batchSize) {
                    for (int i = 0; i < offset.get(); ++i) {
                        this.consumer.accept(list[i]);
                    }
                    response.sendDataResonse(collectedValues);
                    collectedValues.clear();
                    offset.set(0);
                }
            }
            currentKey[0] = e.getKey();
        });
        for (IntermediateOperation intermediateOperation : this.intermediateOperations) {
            stream = intermediateOperation.perform(stream);
        }
        LongStream convertedStream = (LongStream)stream;
        convertedStream.forEach(d -> {
            list[offset.getAndIncrement()] = d;
        });
        if (offset.get() > 0) {
            for (int i = 0; i < offset.get(); ++i) {
                this.consumer.accept(list[i]);
            }
            collectedValues.add(new ImmortalCacheEntry(currentKey[0], currentKey[0]));
        }
        return collectedValues;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public LongConsumer getConsumer() {
        return this.consumer;
    }
}

