/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.enhance;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.spi.ClassTransformer;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.jpa.internal.enhance.EnhancementContextImpl;

public class EnhancingClassTransformerImpl
implements ClassTransformer {
    private final Collection<String> classNames;
    private Enhancer enhancer;

    public EnhancingClassTransformerImpl(Collection<String> incomingClassNames) {
        this.classNames = new ArrayList<String>(incomingClassNames.size());
        this.classNames.addAll(incomingClassNames);
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (this.enhancer == null) {
            this.enhancer = new Enhancer((EnhancementContext)new EnhancementContextImpl(this.classNames, loader));
        }
        try {
            return this.enhancer.enhance(className, classfileBuffer);
        }
        catch (Exception e) {
            throw new IllegalClassFormatException("Error performing enhancement"){

                @Override
                public synchronized Throwable getCause() {
                    return e;
                }
            };
        }
    }
}

