/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.naturalid;

import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.InvalidationCacheAccessDelegate;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.naturalid.ReadOnlyAccess;
import org.hibernate.cache.infinispan.naturalid.ReadWriteAccess;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CacheKeysFactory;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.infinispan.AdvancedCache;

public class NaturalIdRegionImpl
extends BaseTransactionalDataRegion
implements NaturalIdRegion {
    public NaturalIdRegionImpl(AdvancedCache cache, String name, TransactionManager transactionManager, CacheDataDescription metadata, RegionFactory factory, CacheKeysFactory cacheKeysFactory) {
        super(cache, name, transactionManager, metadata, factory, cacheKeysFactory);
    }

    public NaturalIdRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        this.checkAccessType(accessType);
        if (!this.getCacheDataDescription().isMutable()) {
            accessType = AccessType.READ_ONLY;
        }
        InvalidationCacheAccessDelegate delegate = InvalidationCacheAccessDelegate.create(this, this.getValidator());
        switch (accessType) {
            case READ_ONLY: {
                return new ReadOnlyAccess(this, delegate);
            }
            case READ_WRITE: 
            case TRANSACTIONAL: {
                return new ReadWriteAccess(this, delegate);
            }
        }
        throw new CacheException("Unsupported access type [" + accessType.getExternalName() + "]");
    }
}

