/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

@Immutable
public class GetAllOperation<K, V>
extends RetryOnFailureOperation<Map<K, V>> {
    protected final Set<byte[]> keys;

    public GetAllOperation(Codec codec, TransportFactory transportFactory, Set<byte[]> keys, byte[] cacheName, AtomicInteger topologyId, Flag[] flags) {
        super(codec, transportFactory, cacheName, topologyId, flags);
        this.keys = keys;
    }

    @Override
    protected Map<K, V> executeOperation(Transport transport) {
        HeaderParams params = this.writeHeader(transport, (short)47);
        transport.writeVInt(this.keys.size());
        for (byte[] key : this.keys) {
            transport.writeArray(key);
        }
        transport.flush();
        short status = this.readHeaderAndValidate(transport, params);
        int size = transport.readVInt();
        HashMap result = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            Object key = this.codec.readUnmarshallByteArray(transport, status);
            Object value = this.codec.readUnmarshallByteArray(transport, status);
            result.put(key, value);
        }
        return result;
    }

    @Override
    protected Transport getTransport(int retryCount, Set<SocketAddress> failedServers) {
        return this.transportFactory.getTransport(failedServers, this.cacheName);
    }
}

