/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;

public class FacetsCollector
extends SimpleCollector
implements Collector {
    private LeafReaderContext context;
    private Scorer scorer;
    private int totalHits;
    private float[] scores;
    private final boolean keepScores;
    private final List<MatchingDocs> matchingDocs = new ArrayList<MatchingDocs>();
    private Docs docs;

    public FacetsCollector() {
        this(false);
    }

    public FacetsCollector(boolean keepScores) {
        this.keepScores = keepScores;
    }

    protected Docs createDocs(final int maxDoc) {
        return new Docs(){
            private final FixedBitSet bits;
            {
                this.bits = new FixedBitSet(maxDoc);
            }

            @Override
            public void addDoc(int docId) throws IOException {
                this.bits.set(docId);
            }

            @Override
            public DocIdSet getDocIdSet() {
                return new BitDocIdSet((BitSet)this.bits);
            }
        };
    }

    public final boolean getKeepScores() {
        return this.keepScores;
    }

    public List<MatchingDocs> getMatchingDocs() {
        if (this.docs != null) {
            this.matchingDocs.add(new MatchingDocs(this.context, this.docs.getDocIdSet(), this.totalHits, this.scores));
            this.docs = null;
            this.scores = null;
            this.context = null;
        }
        return this.matchingDocs;
    }

    public final void collect(int doc) throws IOException {
        this.docs.addDoc(doc);
        if (this.keepScores) {
            if (this.totalHits >= this.scores.length) {
                float[] newScores = new float[ArrayUtil.oversize((int)(this.totalHits + 1), (int)4)];
                System.arraycopy(this.scores, 0, newScores, 0, this.totalHits);
                this.scores = newScores;
            }
            this.scores[this.totalHits] = this.scorer.score();
        }
        ++this.totalHits;
    }

    public boolean needsScores() {
        return true;
    }

    public final void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        if (this.docs != null) {
            this.matchingDocs.add(new MatchingDocs(this.context, this.docs.getDocIdSet(), this.totalHits, this.scores));
        }
        this.docs = this.createDocs(context.reader().maxDoc());
        this.totalHits = 0;
        if (this.keepScores) {
            this.scores = new float[64];
        }
        this.context = context;
    }

    public static TopDocs search(IndexSearcher searcher, Query q, int n, Collector fc) throws IOException {
        return FacetsCollector.doSearch(searcher, null, q, n, null, false, false, fc);
    }

    public static TopFieldDocs search(IndexSearcher searcher, Query q, int n, Sort sort, Collector fc) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return (TopFieldDocs)FacetsCollector.doSearch(searcher, null, q, n, sort, false, false, fc);
    }

    public static TopFieldDocs search(IndexSearcher searcher, Query q, int n, Sort sort, boolean doDocScores, boolean doMaxScore, Collector fc) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return (TopFieldDocs)FacetsCollector.doSearch(searcher, null, q, n, sort, doDocScores, doMaxScore, fc);
    }

    public static TopDocs searchAfter(IndexSearcher searcher, ScoreDoc after, Query q, int n, Collector fc) throws IOException {
        return FacetsCollector.doSearch(searcher, after, q, n, null, false, false, fc);
    }

    public static TopDocs searchAfter(IndexSearcher searcher, ScoreDoc after, Query q, int n, Sort sort, Collector fc) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return FacetsCollector.doSearch(searcher, after, q, n, sort, false, false, fc);
    }

    public static TopDocs searchAfter(IndexSearcher searcher, ScoreDoc after, Query q, int n, Sort sort, boolean doDocScores, boolean doMaxScore, Collector fc) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must not be null");
        }
        return FacetsCollector.doSearch(searcher, after, q, n, sort, doDocScores, doMaxScore, fc);
    }

    private static TopDocs doSearch(IndexSearcher searcher, ScoreDoc after, Query q, int n, Sort sort, boolean doDocScores, boolean doMaxScore, Collector fc) throws IOException {
        TopScoreDocCollector hitsCollector;
        int limit = searcher.getIndexReader().maxDoc();
        if (limit == 0) {
            limit = 1;
        }
        n = Math.min(n, limit);
        if (after != null && after.doc >= limit) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + after.doc + " limit=" + limit);
        }
        if (sort != null) {
            if (after != null && !(after instanceof FieldDoc)) {
                throw new IllegalArgumentException("after must be a FieldDoc; got " + after);
            }
            boolean fillFields = true;
            hitsCollector = TopFieldCollector.create((Sort)sort, (int)n, (FieldDoc)((FieldDoc)after), (boolean)fillFields, (boolean)doDocScores, (boolean)doMaxScore);
        } else {
            hitsCollector = TopScoreDocCollector.create((int)n, (ScoreDoc)after);
        }
        searcher.search(q, MultiCollector.wrap((Collector[])new Collector[]{hitsCollector, fc}));
        return hitsCollector.topDocs();
    }

    public static final class MatchingDocs {
        public final LeafReaderContext context;
        public final DocIdSet bits;
        public final float[] scores;
        public final int totalHits;

        public MatchingDocs(LeafReaderContext context, DocIdSet bits, int totalHits, float[] scores) {
            this.context = context;
            this.bits = bits;
            this.scores = scores;
            this.totalHits = totalHits;
        }
    }

    protected static abstract class Docs {
        public abstract void addDoc(int var1) throws IOException;

        public abstract DocIdSet getDocIdSet();
    }
}

