/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.jboss.logging.Logger;

public class DefaultResponseCodeHandler
implements HttpHandler {
    protected static final Logger log = Logger.getLogger(DefaultResponseCodeHandler.class);
    protected static final boolean traceEnabled = log.isTraceEnabled();
    private int responseCode;

    public DefaultResponseCodeHandler(int defaultCode) {
        this.responseCode = defaultCode;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.setResponseCode(this.responseCode);
        if (traceEnabled) {
            log.tracef("Setting response code %s for exchange %s", this.responseCode, (Object)exchange);
        }
    }
}

