/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.AutoCreatedQueueManager;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.utils.ReferenceCounterUtil;

public class AutoCreatedQueueManagerImpl
implements AutoCreatedQueueManager {
    private final SimpleString queueName;
    private final ActiveMQServer server;
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            try {
                Queue queue = AutoCreatedQueueManagerImpl.this.server.locateQueue(AutoCreatedQueueManagerImpl.this.queueName);
                long consumerCount = queue.getConsumerCount();
                long messageCount = queue.getMessageCount();
                if (AutoCreatedQueueManagerImpl.this.server.locateQueue(AutoCreatedQueueManagerImpl.this.queueName).getMessageCount() == 0L) {
                    if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                        ActiveMQServerLogger.LOGGER.debug("deleting auto-created queue \"" + AutoCreatedQueueManagerImpl.this.queueName + "\" because consumerCount = " + consumerCount + " and messageCount = " + messageCount);
                    }
                    AutoCreatedQueueManagerImpl.this.server.destroyQueue(AutoCreatedQueueManagerImpl.this.queueName, null, false);
                } else if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQServerLogger.LOGGER.debug("NOT deleting auto-created queue \"" + AutoCreatedQueueManagerImpl.this.queueName + "\" because consumerCount = " + consumerCount + " and messageCount = " + messageCount);
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorRemovingAutoCreatedQueue(e, AutoCreatedQueueManagerImpl.this.queueName);
            }
        }
    };
    private final ReferenceCounterUtil referenceCounterUtil = new ReferenceCounterUtil(this.runnable);

    public AutoCreatedQueueManagerImpl(ActiveMQServer server, SimpleString queueName) {
        this.server = server;
        this.queueName = queueName;
    }

    @Override
    public int increment() {
        return this.referenceCounterUtil.increment();
    }

    @Override
    public int decrement() {
        return this.referenceCounterUtil.decrement();
    }

    @Override
    public SimpleString getQueueName() {
        return this.queueName;
    }
}

