/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.UUID;
import org.apache.lucene.search.ScoreDoc;
import org.infinispan.query.clustered.ClusteredDoc;
import org.infinispan.query.clustered.ClusteredScoreDoc;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.remoting.transport.Address;

public class ClusteredTopDocs {
    private int currentIndex = 0;
    private final NodeTopDocs nodeTopDocs;
    private final UUID id;
    private Address nodeAddress;

    ClusteredTopDocs(NodeTopDocs nodeTopDocs, UUID id) {
        this.nodeTopDocs = nodeTopDocs;
        this.id = id;
    }

    public UUID getId() {
        return this.id;
    }

    public boolean hasNext() {
        return this.currentIndex < this.nodeTopDocs.topDocs.scoreDocs.length;
    }

    public NodeTopDocs getNodeTopDocs() {
        return this.nodeTopDocs;
    }

    public ClusteredDoc getNext() {
        if (this.currentIndex >= this.nodeTopDocs.topDocs.scoreDocs.length) {
            return null;
        }
        ScoreDoc scoreDoc = this.nodeTopDocs.topDocs.scoreDocs[this.currentIndex];
        return new ClusteredScoreDoc(scoreDoc, this.id, this.currentIndex++);
    }

    public void setNodeAddress(Address nodeAddress) {
        this.nodeAddress = nodeAddress;
    }

    public Address getNodeAddress() {
        return this.nodeAddress;
    }
}

