/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.scripting.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.scripting.impl.ExecutionMode;
import org.infinispan.scripting.impl.ExternalizerIds;

public class ScriptMetadata
implements Metadata {
    private final Map<MetadataProperties, String> properties;

    private ScriptMetadata(Map<MetadataProperties, String> properties) {
        this.properties = properties;
    }

    public String property(MetadataProperties property) {
        return this.properties.get((Object)property);
    }

    public String name() {
        return this.properties.get((Object)MetadataProperties.NAME);
    }

    public ExecutionMode mode() {
        return ExecutionMode.valueOf(this.properties.get((Object)MetadataProperties.MODE));
    }

    public long lifespan() {
        return -1L;
    }

    public long maxIdle() {
        return -1L;
    }

    public EntryVersion version() {
        return null;
    }

    public Builder builder() {
        return new Builder().properties(this.properties);
    }

    public String toString() {
        return "ScriptMetadata [properties=" + this.properties + "]";
    }

    public static class Externalizer
    extends AbstractExternalizer<ScriptMetadata> {
        private static final long serialVersionUID = 6882540247700043640L;

        public Integer getId() {
            return ExternalizerIds.SCRIPT_METADATA;
        }

        public Set<Class<? extends ScriptMetadata>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{ScriptMetadata.class});
        }

        public void writeObject(ObjectOutput output, ScriptMetadata object) throws IOException {
            output.writeInt(object.properties.size());
            for (Map.Entry e : object.properties.entrySet()) {
                output.writeUTF(((MetadataProperties)((Object)e.getKey())).name());
                output.writeUTF((String)e.getValue());
            }
        }

        public ScriptMetadata readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Builder builder = new Builder();
            int size = input.readInt();
            for (int i = 0; i < size; ++i) {
                String key = input.readUTF();
                String value = input.readUTF();
                builder.property(MetadataProperties.valueOf(key), value);
            }
            return builder.build();
        }
    }

    public static class Builder
    implements Metadata.Builder {
        private Map<MetadataProperties, String> properties = new HashMap<MetadataProperties, String>(4);

        public Builder property(MetadataProperties property, String value) {
            this.properties.put(property, value);
            return this;
        }

        Builder properties(Map<MetadataProperties, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder lifespan(long time, TimeUnit unit) {
            return this;
        }

        public Builder lifespan(long time) {
            return this;
        }

        public Builder maxIdle(long time, TimeUnit unit) {
            return this;
        }

        public Builder maxIdle(long time) {
            return this;
        }

        public Builder version(EntryVersion version) {
            return this;
        }

        public ScriptMetadata build() {
            return new ScriptMetadata(this.properties);
        }

        public Builder merge(Metadata metadata) {
            return this;
        }
    }

    public static enum MetadataProperties {
        NAME("name"),
        LANGUAGE("language"),
        MODE("mode"),
        REDUCER("reducer"),
        COLLATOR("collator"),
        COMBINER("combiner"),
        EXTENSION("extension");

        private final String s;

        private MetadataProperties(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }
    }
}

