/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.aggregation;

import org.infinispan.objectfilter.PropertyPath;
import org.infinispan.objectfilter.impl.aggregation.AvgAccumulator;
import org.infinispan.objectfilter.impl.aggregation.CountAccumulator;
import org.infinispan.objectfilter.impl.aggregation.MaxAccumulator;
import org.infinispan.objectfilter.impl.aggregation.MinAccumulator;
import org.infinispan.objectfilter.impl.aggregation.SumAccumulator;

public abstract class FieldAccumulator {
    protected final int inPos;
    protected final int outPos;

    protected FieldAccumulator(int inPos, int outPos) {
        this.inPos = inPos;
        this.outPos = outPos;
    }

    public void init(Object[] accRow) {
    }

    public abstract void update(Object[] var1, Object[] var2);

    public void finish(Object[] accRow) {
    }

    public static FieldAccumulator makeAccumulator(PropertyPath.AggregationType aggregationType, int inColumn, int outColumn, Class<?> propertyType) {
        switch (aggregationType) {
            case SUM: {
                return new SumAccumulator(inColumn, outColumn, propertyType);
            }
            case AVG: {
                return new AvgAccumulator(inColumn, outColumn, propertyType);
            }
            case MIN: {
                return new MinAccumulator(inColumn, outColumn, propertyType);
            }
            case MAX: {
                return new MaxAccumulator(inColumn, outColumn, propertyType);
            }
            case COUNT: {
                return new CountAccumulator(inColumn, outColumn);
            }
        }
        throw new IllegalArgumentException("Aggregation " + aggregationType.name() + " is not supported");
    }

    public static Class<?> getOutputType(PropertyPath.AggregationType aggregationType, Class<?> propertyType) {
        if (aggregationType == PropertyPath.AggregationType.AVG) {
            return Double.class;
        }
        if (aggregationType == PropertyPath.AggregationType.COUNT) {
            return Long.class;
        }
        if (aggregationType == PropertyPath.AggregationType.SUM) {
            return SumAccumulator.getOutputType(propertyType);
        }
        return propertyType;
    }
}

