/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.hql;

import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.ast.spi.PropertyHelper;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.util.DateHelper;
import org.infinispan.objectfilter.impl.util.StringHelper;
import org.jboss.logging.Logger;

public abstract class ObjectPropertyHelper<TypeMetadata>
implements PropertyHelper {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)ObjectPropertyHelper.class.getName());
    protected final EntityNamesResolver entityNamesResolver;

    protected ObjectPropertyHelper(EntityNamesResolver entityNamesResolver) {
        this.entityNamesResolver = entityNamesResolver;
    }

    public Object convertToPropertyType(String entityType, List<String> propertyPath, String value) {
        Class<?> propertyType = this.getPrimitivePropertyType(entityType, propertyPath);
        if (propertyType == null) {
            throw log.getPredicatesOnCompleteEmbeddedEntitiesNotAllowedException(StringHelper.join(propertyPath, "."));
        }
        if (Date.class.isAssignableFrom(propertyType)) {
            try {
                return DateHelper.getJpaDateFormat().parse(value);
            }
            catch (ParseException e) {
                throw log.getInvalidDateLiteralException(value);
            }
        }
        if (Instant.class.isAssignableFrom(propertyType)) {
            return Instant.parse(value);
        }
        if (Enum.class.isAssignableFrom(propertyType)) {
            try {
                return Enum.valueOf(propertyType, value);
            }
            catch (IllegalArgumentException e) {
                throw log.getInvalidEnumLiteralException(value, propertyType.getName());
            }
        }
        if (propertyType == String.class) {
            return value;
        }
        if (propertyType == Character.class || propertyType == Character.TYPE) {
            return Character.valueOf(value.charAt(0));
        }
        try {
            if (propertyType == Double.class || propertyType == Double.TYPE) {
                return Double.valueOf(value);
            }
            if (propertyType == Float.class || propertyType == Float.TYPE) {
                return Float.valueOf(value);
            }
            if (propertyType == Long.class || propertyType == Long.TYPE) {
                return Long.valueOf(value);
            }
            if (propertyType == Integer.class || propertyType == Integer.TYPE) {
                return Integer.valueOf(value);
            }
            if (propertyType == Short.class || propertyType == Short.TYPE) {
                return Short.valueOf(value);
            }
            if (propertyType == Byte.class || propertyType == Byte.TYPE) {
                return Byte.valueOf(value);
            }
        }
        catch (NumberFormatException ex) {
            throw log.getInvalidNumericLiteralException(value);
        }
        if (propertyType == Boolean.class || propertyType == Boolean.TYPE) {
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            throw log.getInvalidBooleanLiteralException(value);
        }
        return value;
    }

    public abstract Class<?> getPrimitivePropertyType(String var1, List<String> var2);

    public abstract boolean hasProperty(String var1, List<String> var2);

    public abstract boolean hasEmbeddedProperty(String var1, List<String> var2);

    public abstract boolean isRepeatedProperty(String var1, List<String> var2);

    public abstract TypeMetadata getEntityMetadata(String var1);

    public Object convertToBackendType(String entityType, List<String> propertyPath, Object value) {
        return value;
    }
}

