/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.objectfilter.impl.FilterRegistry;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.objectfilter.impl.predicateindex.FilterEvalContext;
import org.infinispan.objectfilter.impl.predicateindex.Predicate;

public abstract class MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId extends Comparable<AttributeId>> {
    protected AttributeNode<AttributeMetadata, AttributeId> rootNode;
    protected AttributeNode<AttributeMetadata, AttributeId> currentNode;
    private final Object userContext;
    private final Object instance;
    private final Object eventType;
    private FilterEvalContext singleFilterContext;
    private FilterEvalContext[] filterContexts;
    private List<FilterSubscriptionImpl> filterSubscriptions;
    private Map<Predicate<?>, Counter> suspendedSubscriptionCounts;

    protected MatcherEvalContext(Object userContext, Object instance, Object eventType) {
        this.userContext = userContext;
        this.instance = instance;
        this.eventType = eventType;
    }

    public abstract TypeMetadata getEntityType();

    public Object getInstance() {
        return this.instance;
    }

    public Object getUserContext() {
        return this.userContext;
    }

    public Object getEventType() {
        return this.eventType;
    }

    public void initMultiFilterContext(FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId> filterRegistry) {
        this.rootNode = filterRegistry.getPredicateIndex().getRoot();
        this.suspendedSubscriptionCounts = new HashMap();
        this.filterSubscriptions = filterRegistry.getFilterSubscriptions();
        this.filterContexts = new FilterEvalContext[this.filterSubscriptions.size()];
    }

    public FilterEvalContext initSingleFilterContext(FilterSubscriptionImpl filterSubscription) {
        this.singleFilterContext = new FilterEvalContext(this, filterSubscription);
        return this.singleFilterContext;
    }

    private boolean isSingleFilter() {
        return this.singleFilterContext != null;
    }

    public FilterEvalContext getFilterEvalContext(FilterSubscriptionImpl filterSubscription) {
        if (this.isSingleFilter()) {
            return this.singleFilterContext;
        }
        FilterEvalContext filterEvalContext = this.filterContexts[filterSubscription.index];
        if (filterEvalContext == null) {
            this.filterContexts[filterSubscription.index] = filterEvalContext = new FilterEvalContext(this, filterSubscription);
        }
        return filterEvalContext;
    }

    public void addSuspendedSubscription(Predicate<?> predicate) {
        if (this.isSingleFilter()) {
            return;
        }
        Counter counter = this.suspendedSubscriptionCounts.get(predicate);
        if (counter == null) {
            counter = new Counter();
            this.suspendedSubscriptionCounts.put(predicate, counter);
        }
        ++counter.value;
    }

    public int getSuspendedSubscriptionsCounter(Predicate<AttributeId> predicate) {
        if (this.isSingleFilter()) {
            return -1;
        }
        Counter counter = this.suspendedSubscriptionCounts.get(predicate);
        return counter == null ? 0 : counter.value;
    }

    public AttributeNode<AttributeMetadata, AttributeId> getRootNode() {
        return this.rootNode;
    }

    public void process(AttributeNode<AttributeMetadata, AttributeId> node) {
        this.currentNode = node;
        this.processAttributes(this.currentNode, this.instance);
        if (this.filterContexts != null) {
            this.notifySubscribers();
        }
    }

    private void notifySubscribers() {
        for (int i = 0; i < this.filterContexts.length; ++i) {
            FilterEvalContext filterEvalContext = this.filterContexts[i];
            FilterSubscriptionImpl s = this.filterSubscriptions.get(i);
            if (filterEvalContext == null) {
                if (s.getBETree().getChildCounters()[0] != 0) continue;
                filterEvalContext = new FilterEvalContext(this, s);
            }
            if (!filterEvalContext.isMatching()) continue;
            s.getCallback().onFilterResult(this.userContext, this.instance, this.eventType, filterEvalContext.getProjection(), filterEvalContext.getSortProjection());
        }
    }

    protected abstract void processAttributes(AttributeNode<AttributeMetadata, AttributeId> var1, Object var2);

    private static final class Counter {
        int value;

        private Counter() {
        }
    }
}

