/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import org.wildfly.clustering.ee.infinispan.Remover;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.SessionMetaDataFactory;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class ExpiredSessionRemover<V, L>
implements Remover<String> {
    private final SessionMetaDataFactory<V, L> factory;
    private final Remover<String> remover;

    public ExpiredSessionRemover(SessionMetaDataFactory<V, L> factory, Remover<String> remover) {
        this.factory = factory;
        this.remover = remover;
    }

    public void remove(String id) {
        ImmutableSessionMetaData metaData;
        Object value = this.factory.tryValue(id);
        if (value != null && (metaData = this.factory.createImmutableSessionMetaData(id, value)).isExpired()) {
            InfinispanWebLogger.ROOT_LOGGER.tracef("Session %s has expired.", id);
            this.remover.remove((Object)id);
        }
    }
}

