/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.sso.coarse;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.Mutator;
import org.wildfly.clustering.infinispan.spi.distribution.Key;
import org.wildfly.clustering.marshalling.jboss.InvalidSerializedFormException;
import org.wildfly.clustering.marshalling.jboss.MarshalledValue;
import org.wildfly.clustering.marshalling.jboss.Marshaller;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.web.LocalContextFactory;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.sso.AuthenticationEntry;
import org.wildfly.clustering.web.infinispan.sso.AuthenticationKey;
import org.wildfly.clustering.web.infinispan.sso.InfinispanSSO;
import org.wildfly.clustering.web.infinispan.sso.SSOFactory;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSSOEntry;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessions;
import org.wildfly.clustering.web.infinispan.sso.coarse.CoarseSessionsKey;
import org.wildfly.clustering.web.sso.SSO;

public class CoarseSSOFactory<A, D, L>
implements SSOFactory<CoarseSSOEntry<A, D, L>, A, D, L> {
    private final Cache<AuthenticationKey, AuthenticationEntry<A, D, L>> authenticationCache;
    private final Cache<CoarseSessionsKey, Map<D, String>> sessionsCache;
    private final Marshaller<A, MarshalledValue<A, MarshallingContext>, MarshallingContext> marshaller;
    private final LocalContextFactory<L> localContextFactory;

    public CoarseSSOFactory(Cache<? extends Key<String>, ?> cache, Marshaller<A, MarshalledValue<A, MarshallingContext>, MarshallingContext> marshaller, LocalContextFactory<L> localContextFactory, boolean lockOnRead) {
        this.authenticationCache = lockOnRead ? cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_WRITE_LOCK}) : cache;
        this.sessionsCache = cache;
        this.marshaller = marshaller;
        this.localContextFactory = localContextFactory;
    }

    @Override
    public SSO<A, D, L> createSSO(String id, CoarseSSOEntry<A, D, L> entry) {
        CoarseSessionsKey sessionsKey = new CoarseSessionsKey(id);
        Map<D, String> sessionsValue = entry.getSessions();
        CacheEntryMutator sessionsMutator = new CacheEntryMutator(this.sessionsCache, (Object)sessionsKey, sessionsValue);
        CoarseSessions<D> sessions = new CoarseSessions<D>(sessionsValue, (Mutator)sessionsMutator);
        return new InfinispanSSO<A, D, L>(id, entry.getAuthentication(), sessions, entry.getLocalContext(), this.localContextFactory, this);
    }

    public CoarseSSOEntry<A, D, L> createValue(String id, A authentication) {
        AuthenticationKey key = new AuthenticationKey(id);
        AuthenticationEntry entry = new AuthenticationEntry((MarshalledValue)this.marshaller.write(authentication));
        AuthenticationEntry existingEntry = (AuthenticationEntry)this.authenticationCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)key, entry);
        if (existingEntry != null) {
            Map value = (Map)this.sessionsCache.get((Object)new CoarseSessionsKey(id));
            return new CoarseSSOEntry(authentication, entry.getLocalContext(), value);
        }
        ConcurrentHashMap map = new ConcurrentHashMap();
        ConcurrentHashMap existingMap = (ConcurrentHashMap)this.sessionsCache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).putIfAbsent((Object)new CoarseSessionsKey(id), map);
        return new CoarseSSOEntry(authentication, entry.getLocalContext(), existingMap != null ? existingMap : map);
    }

    public CoarseSSOEntry<A, D, L> findValue(String id) {
        Map map;
        AuthenticationKey key = new AuthenticationKey(id);
        AuthenticationEntry entry = (AuthenticationEntry)this.authenticationCache.get((Object)key);
        if (entry != null && (map = (Map)this.sessionsCache.get((Object)new CoarseSessionsKey(id))) != null) {
            try {
                Object authentication = this.marshaller.read(entry.getAuthentication());
                return new CoarseSSOEntry(authentication, entry.getLocalContext(), map);
            }
            catch (InvalidSerializedFormException e) {
                InfinispanWebLogger.ROOT_LOGGER.failedToActivateAuthentication(e, id);
                this.remove(id);
            }
        }
        return null;
    }

    public void remove(String id) {
        this.authenticationCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new AuthenticationKey(id));
        this.sessionsCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).remove((Object)new CoarseSessionsKey(id));
    }
}

