/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoverAtomicAction;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.util.Enumeration;
import java.util.Vector;

public class AtomicActionRecoveryModule
implements RecoveryModule {
    private String _transactionType = new AtomicAction().type();
    private Vector _transactionUidVector = null;
    private static RecoveryStore _recoveryStore = null;
    private TransactionStatusConnectionManager _transactionStatusConnectionMgr;

    public AtomicActionRecoveryModule() {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)"AtomicActionRecoveryModule created");
        }
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
        this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
    }

    @Override
    public void periodicWorkFirstPass() {
        boolean AtomicActions = false;
        InputObjectState aa_uids = new InputObjectState();
        try {
            if (tsLogger.logger.isDebugEnabled()) {
                tsLogger.logger.debug((Object)"AtomicActionRecoveryModule first pass");
            }
            AtomicActions = _recoveryStore.allObjUids(this._transactionType, aa_uids);
        }
        catch (ObjectStoreException ex) {
            tsLogger.i18NLogger.warn_recovery_AtomicActionRecoveryModule_1(ex);
        }
        if (AtomicActions) {
            this._transactionUidVector = this.processTransactions(aa_uids);
        }
    }

    @Override
    public void periodicWorkSecondPass() {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)"AtomicActionRecoveryModule second pass");
        }
        this.processTransactionsStatus();
    }

    protected AtomicActionRecoveryModule(String type) {
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)"AtomicActionRecoveryModule created");
        }
        if (_recoveryStore == null) {
            _recoveryStore = StoreManager.getRecoveryStore();
        }
        this._transactionStatusConnectionMgr = new TransactionStatusConnectionManager();
        this._transactionType = type;
    }

    private void doRecoverTransaction(Uid recoverUid) {
        boolean commitThisTransaction = true;
        int theStatus = this._transactionStatusConnectionMgr.getTransactionStatus(this._transactionType, recoverUid);
        boolean inFlight = this.isTransactionInMidFlight(theStatus);
        String Status2 = ActionStatus.stringForm(theStatus);
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("transaction type is " + this._transactionType + " uid is " + recoverUid.toString() + "\n ActionStatus is " + Status2 + " in flight is " + inFlight));
        }
        if (!inFlight) {
            try {
                RecoverAtomicAction rcvAtomicAction = new RecoverAtomicAction(recoverUid, theStatus);
                rcvAtomicAction.replayPhase2();
            }
            catch (Exception ex) {
                tsLogger.i18NLogger.warn_recovery_AtomicActionRecoveryModule_2(recoverUid, ex);
            }
        }
    }

    private boolean isTransactionInMidFlight(int status) {
        boolean inFlight = false;
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                inFlight = true;
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                inFlight = false;
                break;
            }
            default: {
                inFlight = false;
            }
        }
        return inFlight;
    }

    private Vector processTransactions(InputObjectState uids) {
        Vector<Uid> uidVector = new Vector<Uid>();
        if (tsLogger.logger.isDebugEnabled()) {
            tsLogger.logger.debug((Object)("processing " + this._transactionType + " transactions"));
        }
        Uid theUid = null;
        boolean moreUids = true;
        while (moreUids) {
            try {
                theUid = UidHelper.unpackFrom(uids);
                if (theUid.equals(Uid.nullUid())) {
                    moreUids = false;
                    continue;
                }
                Uid newUid = new Uid(theUid);
                if (tsLogger.logger.isDebugEnabled()) {
                    tsLogger.logger.debug((Object)("found transaction " + newUid));
                }
                uidVector.addElement(newUid);
            }
            catch (Exception ex) {
                moreUids = false;
            }
        }
        return uidVector;
    }

    private void processTransactionsStatus() {
        if (this._transactionUidVector != null) {
            Enumeration transactionUidEnum = this._transactionUidVector.elements();
            while (transactionUidEnum.hasMoreElements()) {
                Uid currentUid = (Uid)transactionUidEnum.nextElement();
                try {
                    if (_recoveryStore.currentState(currentUid, this._transactionType) == -1) continue;
                    this.doRecoverTransaction(currentUid);
                }
                catch (ObjectStoreException ex) {
                    tsLogger.i18NLogger.warn_recovery_AtomicActionRecoveryModule_3(currentUid, ex);
                }
            }
        }
    }
}

