/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.deployments;

import java.util.List;
import org.infinispan.server.endpoint.Constants;
import org.infinispan.server.endpoint.EndpointLogger;
import org.infinispan.server.endpoint.deployments.AbstractServerExtensionProcessor;
import org.infinispan.server.endpoint.subsystem.ExtensionManagerService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractNamedFactoryExtensionProcessor<T>
extends AbstractServerExtensionProcessor<T> {
    private static final DotName NAMED_FACTORY = DotName.createSimple((String)"org.infinispan.filter.NamedFactory");
    private final ServiceName extensionManagerServiceName;

    protected AbstractNamedFactoryExtensionProcessor(ServiceName extensionManagerServiceName) {
        this.extensionManagerServiceName = extensionManagerServiceName;
    }

    @Override
    public final void installService(DeploymentPhaseContext ctx, String serviceName, T instance) {
        CompositeIndex index = (CompositeIndex)ctx.getDeploymentUnit().getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        List annotations = index.getAnnotations(NAMED_FACTORY);
        if (annotations.isEmpty()) {
            EndpointLogger.ROOT_LOGGER.noFactoryName(this.getServiceClass().getName());
        } else {
            for (AnnotationInstance annotation : annotations) {
                AnnotationTarget annotationTarget = annotation.target();
                if (!(annotationTarget instanceof ClassInfo)) continue;
                ClassInfo classInfo = (ClassInfo)annotationTarget;
                DotName target = DotName.createSimple((String)serviceName);
                if (!classInfo.name().equals((Object)target)) continue;
                String nameValue = annotation.value("name").asString();
                AbstractExtensionManagerService<T> service = this.createService(nameValue, instance);
                ServiceName extensionServiceName = Constants.DATAGRID.append(new String[]{service.getServiceTypeName(), nameValue.replaceAll("\\.", "_")});
                ServiceBuilder serviceBuilder = ctx.getServiceTarget().addService(extensionServiceName, service);
                serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).addDependency(this.extensionManagerServiceName, ExtensionManagerService.class, service.getExtensionManager());
                serviceBuilder.install();
            }
        }
    }

    public abstract AbstractExtensionManagerService<T> createService(String var1, T var2);

    public static abstract class AbstractExtensionManagerService<T>
    implements Service<T> {
        protected final String name;
        protected final T extension;
        protected final InjectedValue<ExtensionManagerService> extensionManager = new InjectedValue();

        protected AbstractExtensionManagerService(String name, T extension) {
            assert (name != null) : EndpointLogger.ROOT_LOGGER.nullVar("name");
            assert (extension != null) : EndpointLogger.ROOT_LOGGER.nullVar(this.getServiceTypeName());
            this.extension = extension;
            this.name = name;
        }

        public InjectedValue<ExtensionManagerService> getExtensionManager() {
            return this.extensionManager;
        }

        public abstract String getServiceTypeName();
    }
}

