/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console.man.parser;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.man.parser.ManParserUtil;
import org.jboss.aesh.parser.Parser;

public class ManParameter {
    final List<String> out = new ArrayList<String>();
    private static final String argPad = "  ";
    private static final String textPad = "    ";

    public ManParameter parseParams(List<String> input, int columns) {
        this.out.add(argPad + ManParserUtil.convertStringToAnsi(input.get(0)));
        input.remove(0);
        if (!input.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (String in : input) {
                if (in.trim().length() <= 0) continue;
                builder.append(in.trim()).append(' ');
            }
            if (builder.length() > 0) {
                for (String s : Parser.splitBySizeKeepWords(builder.toString(), columns - textPad.length())) {
                    this.out.add(textPad + ManParserUtil.convertStringToAnsi(s));
                }
            }
            if (this.out.size() > 0) {
                this.out.add(" ");
            }
        }
        return this;
    }

    public List<String> getAsList() {
        return this.out;
    }

    public String printToTerminal() {
        StringBuilder builder = new StringBuilder();
        for (String s : this.out) {
            builder.append(s).append(Config.getLineSeparator());
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManParameter)) {
            return false;
        }
        ManParameter that = (ManParameter)o;
        return !(this.out == null ? that.out != null : !this.out.equals(that.out));
    }

    public int hashCode() {
        return this.out != null ? this.out.hashCode() : 0;
    }
}

