/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.servlet.api.Deployment;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.wildfly.clustering.web.session.SessionContext;

public class UndertowSessionContext
implements SessionContext,
HttpSessionListener,
HttpSessionAttributeListener {
    private final Deployment deployment;

    public UndertowSessionContext(Deployment deployment) {
        this.deployment = deployment;
    }

    public Collection<HttpSessionListener> getSessionListeners() {
        return Collections.singleton(this);
    }

    public Collection<HttpSessionAttributeListener> getSessionAttributeListeners() {
        return Collections.singleton(this);
    }

    public ServletContext getServletContext() {
        return this.deployment.getServletContext();
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        this.deployment.getApplicationListeners().httpSessionAttributeAdded(event.getSession(), event.getName(), event.getValue());
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        this.deployment.getApplicationListeners().httpSessionAttributeRemoved(event.getSession(), event.getName(), event.getValue());
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        this.deployment.getApplicationListeners().httpSessionAttributeReplaced(event.getSession(), event.getName(), event.getValue());
    }

    public void sessionCreated(HttpSessionEvent event) {
        this.deployment.getApplicationListeners().sessionCreated(event.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        this.deployment.getApplicationListeners().sessionDestroyed(event.getSession());
    }
}

