/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;

public final class PrivilegedWithCombinerInterceptor
implements Interceptor {
    private static final PrivilegedWithCombinerInterceptor INSTANCE = new PrivilegedWithCombinerInterceptor();
    private static final InterceptorFactory FACTORY = new ImmediateInterceptorFactory(INSTANCE);
    private static final RuntimePermission PERMISSION = new RuntimePermission("getPrivilegedWithCombinerInterceptor");

    public static PrivilegedWithCombinerInterceptor getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERMISSION);
        }
        return INSTANCE;
    }

    public static InterceptorFactory getFactory() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERMISSION);
        }
        return FACTORY;
    }

    private PrivilegedWithCombinerInterceptor() {
    }

    @Override
    public Object processInvocation(InterceptorContext context) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                return AccessController.doPrivilegedWithCombiner(context);
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
        return context.run();
    }
}

