/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotated;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedConstructor;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedField;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedMethod;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.resources.ReflectionCache;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.security.GetDeclaredConstructorsAction;
import org.jboss.weld.security.GetDeclaredFieldsAction;
import org.jboss.weld.security.GetDeclaredMethodsAction;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

@SuppressWarnings(value={"SE_BAD_FIELD", "SE_NO_SUITABLE_CONSTRUCTOR", "SE_BAD_FIELD_STORE", "SE_NO_SERIALVERSIONID"}, justification="False positive from FindBugs - serialization is handled by SerializationProxy.")
public class BackedAnnotatedType<X>
extends BackedAnnotated
implements SlimAnnotatedType<X>,
Serializable {
    private final Class<X> javaClass;
    private final LazyValueHolder<Set<AnnotatedConstructor<X>>> constructors;
    private final LazyValueHolder<Set<AnnotatedMethod<? super X>>> methods;
    private final LazyValueHolder<Set<AnnotatedField<? super X>>> fields;
    private final SharedObjectCache sharedObjectCache;
    private final ReflectionCache reflectionCache;
    private final AnnotatedTypeIdentifier identifier;

    public static <X> BackedAnnotatedType<X> of(Class<X> javaClass, SharedObjectCache sharedObjectCache, ReflectionCache reflectionCache, String contextId, String bdaId) {
        return BackedAnnotatedType.of(javaClass, javaClass, sharedObjectCache, reflectionCache, contextId, bdaId);
    }

    public static <X> BackedAnnotatedType<X> of(Class<X> javaClass, Type baseType, SharedObjectCache sharedObjectCache, ReflectionCache reflectionCache, String contextId, String bdaId) {
        return new BackedAnnotatedType<X>(javaClass, baseType, sharedObjectCache, reflectionCache, contextId, bdaId);
    }

    private BackedAnnotatedType(Class<X> rawType, Type baseType, SharedObjectCache sharedObjectCache, ReflectionCache reflectionCache, String contextId, String bdaId) {
        super(baseType, sharedObjectCache);
        this.javaClass = rawType;
        this.sharedObjectCache = sharedObjectCache;
        this.reflectionCache = reflectionCache;
        this.constructors = new BackedAnnotatedConstructors();
        this.fields = new BackedAnnotatedFields();
        this.methods = new BackedAnnotatedMethods();
        this.identifier = AnnotatedTypeIdentifier.forBackedAnnotatedType(contextId, rawType, baseType, bdaId);
    }

    @Override
    protected LazyValueHolder<Set<Type>> initTypeClosure(Type baseType, SharedObjectCache cache) {
        return cache.getTypeClosureHolder(Types.getCanonicalType(baseType));
    }

    @Override
    protected AnnotatedElement getAnnotatedElement() {
        return this.javaClass;
    }

    public Class<X> getJavaClass() {
        return this.javaClass;
    }

    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this.constructors.get();
    }

    public Set<AnnotatedMethod<? super X>> getMethods() {
        return this.methods.get();
    }

    public Set<AnnotatedField<? super X>> getFields() {
        return this.fields.get();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (T)((Annotation)annotationType.cast(annotation));
        }
        return null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return this.reflectionCache.getBackedAnnotatedTypeAnnotationSet(this.javaClass);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BackedAnnotatedType) {
            BackedAnnotatedType that = (BackedAnnotatedType)Reflections.cast(obj);
            return Objects.equal((Object)this.identifier, (Object)that.identifier);
        }
        return false;
    }

    public String toString() {
        return Formats.formatAnnotatedType(this);
    }

    @Override
    public void clear() {
        this.constructors.clear();
        this.fields.clear();
        this.methods.clear();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SlimAnnotatedType.SerializationProxy(this.getIdentifier());
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw BeanLogger.LOG.serializationProxyRequired();
    }

    @Override
    public ReflectionCache getReflectionCache() {
        return this.reflectionCache;
    }

    @Override
    public AnnotatedTypeIdentifier getIdentifier() {
        return this.identifier;
    }

    private class BackedAnnotatedMethods
    extends EagerlyInitializedLazyValueHolder<Set<AnnotatedMethod<? super X>>> {
        private BackedAnnotatedMethods() {
        }

        @Override
        protected Set<AnnotatedMethod<? super X>> computeValue() {
            ArraySet methods = new ArraySet();
            for (Class clazz = BackedAnnotatedType.this.javaClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
                for (Method method : AccessController.doPrivileged(new GetDeclaredMethodsAction(clazz))) {
                    methods.add(BackedAnnotatedMethod.of(method, BackedAnnotatedType.this, BackedAnnotatedType.this.sharedObjectCache));
                }
            }
            return WeldCollections.immutableSet(methods);
        }
    }

    private class BackedAnnotatedFields
    extends EagerlyInitializedLazyValueHolder<Set<AnnotatedField<? super X>>> {
        private BackedAnnotatedFields() {
        }

        @Override
        protected Set<AnnotatedField<? super X>> computeValue() {
            ArraySet fields = new ArraySet();
            for (Class clazz = BackedAnnotatedType.this.javaClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : AccessController.doPrivileged(new GetDeclaredFieldsAction(clazz))) {
                    fields.add(BackedAnnotatedField.of(field, BackedAnnotatedType.this, BackedAnnotatedType.this.sharedObjectCache));
                }
            }
            return WeldCollections.immutableSet(fields);
        }
    }

    private class BackedAnnotatedConstructors
    extends EagerlyInitializedLazyValueHolder<Set<AnnotatedConstructor<X>>> {
        private BackedAnnotatedConstructors() {
        }

        @Override
        protected Set<AnnotatedConstructor<X>> computeValue() {
            Constructor<?>[] declaredConstructors = AccessController.doPrivileged(new GetDeclaredConstructorsAction(BackedAnnotatedType.this.javaClass));
            ArraySet constructors = new ArraySet(declaredConstructors.length);
            for (Constructor<?> constructor : declaredConstructors) {
                Constructor c = (Constructor)Reflections.cast(constructor);
                constructors.add(BackedAnnotatedConstructor.of(c, BackedAnnotatedType.this, BackedAnnotatedType.this.sharedObjectCache));
            }
            return WeldCollections.immutableSet(constructors);
        }
    }

    private abstract class EagerlyInitializedLazyValueHolder<T>
    extends LazyValueHolder<T> {
        public EagerlyInitializedLazyValueHolder() {
            this.get();
        }
    }
}

