/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.ArrayList;
import java.util.Collection;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.server.group.InfinispanNodeFactory;
import org.wildfly.clustering.server.group.JGroupsNodeFactory;

public class CacheNodeFactory
implements InfinispanNodeFactory {
    private final JGroupsNodeFactory factory;

    public CacheNodeFactory(JGroupsNodeFactory factory) {
        this.factory = factory;
    }

    public Node createNode(Address address) {
        return this.factory.createNode(CacheNodeFactory.toJGroupsAddress(address));
    }

    @Override
    public void invalidate(Collection<Address> addresses) {
        if (!addresses.isEmpty()) {
            ArrayList<org.jgroups.Address> jgroupsAddresses = new ArrayList<org.jgroups.Address>(addresses.size());
            for (Address address : addresses) {
                jgroupsAddresses.add(CacheNodeFactory.toJGroupsAddress(address));
            }
            this.factory.invalidate(jgroupsAddresses);
        }
    }

    private static org.jgroups.Address toJGroupsAddress(Address address) {
        if (address == null) {
            return null;
        }
        if (address instanceof JGroupsAddress) {
            JGroupsAddress jgroupsAddress = (JGroupsAddress)address;
            return jgroupsAddress.getJGroupsAddress();
        }
        throw new IllegalArgumentException(address.toString());
    }
}

