/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Collections;
import java.util.Set;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.LocalCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EvictCommand
extends RemoveCommand
implements LocalCommand {
    private static final Log log = LogFactory.getLog(EvictCommand.class);
    private final InternalEntryFactory factory;

    public EvictCommand(Object key, CacheNotifier notifier, Set<Flag> flags, CommandInvocationId commandInvocationId, InternalEntryFactory factory) {
        super(key, null, notifier, flags, null, commandInvocationId);
        this.factory = factory;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitEvictCommand(ctx, this);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.key == null) {
            throw new NullPointerException("Key is null!!");
        }
        super.perform(ctx);
        return null;
    }

    @Override
    public void notify(InvocationContext ctx, Object value, Metadata previousMetadata, boolean isPre) {
        if (!isPre) {
            if (log.isTraceEnabled()) {
                log.tracef("Notify eviction listeners for key=%s", this.key);
            }
            this.notifier.notifyCacheEntriesEvicted(Collections.singleton(this.factory.create(this.key, value, previousMetadata)), ctx, this);
        }
    }

    @Override
    public byte getCommandId() {
        return -1;
    }

    @Override
    public String toString() {
        return "EvictCommand{key=" + this.key + ", value=" + this.value + ", flags=" + this.flags + "}";
    }

    @Override
    public boolean readsExistingValues() {
        return false;
    }
}

