/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.context.InvocationContext;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.TransactionInfo;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateRequestCommand
extends BaseRpcCommand
implements TopologyAffectedCommand {
    private static final Log log = LogFactory.getLog(StateRequestCommand.class);
    public static final byte COMMAND_ID = 15;
    private Type type = Type.CANCEL_STATE_TRANSFER;
    private int topologyId;
    private Set<Integer> segments;
    private StateProvider stateProvider;

    private StateRequestCommand() {
        super(null);
    }

    public StateRequestCommand(String cacheName) {
        super(cacheName);
    }

    public StateRequestCommand(String cacheName, Type type, Address origin, int topologyId, Set<Integer> segments) {
        super(cacheName);
        this.type = type;
        this.setOrigin(origin);
        this.topologyId = topologyId;
        this.segments = segments;
    }

    public void init(StateProvider stateProvider) {
        this.stateProvider = stateProvider;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(this.cacheName, trace);
        try {
            switch (this.type) {
                case GET_TRANSACTIONS: {
                    List<TransactionInfo> list = this.stateProvider.getTransactionsForSegments(this.getOrigin(), this.topologyId, this.segments);
                    return list;
                }
                case START_STATE_TRANSFER: {
                    this.stateProvider.startOutboundTransfer(this.getOrigin(), this.topologyId, this.segments);
                    Boolean bl = true;
                    return bl;
                }
                case CANCEL_STATE_TRANSFER: {
                    this.stateProvider.cancelOutboundTransfer(this.getOrigin(), this.topologyId, this.segments);
                    Object var3_5 = null;
                    return var3_5;
                }
                case GET_CACHE_LISTENERS: {
                    Collection<DistributedCallable> collection = this.stateProvider.getClusterListenersToInstall();
                    return collection;
                }
            }
            throw new CacheException("Unknown state request command type: " + (Object)((Object)this.type));
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    @Override
    public boolean isReturnValueExpected() {
        return this.type != Type.CANCEL_STATE_TRANSFER;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
    }

    public Set<Integer> getSegments() {
        return this.segments;
    }

    @Override
    public byte getCommandId() {
        return 15;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{(byte)this.type.ordinal(), this.getOrigin(), this.topologyId, this.segments};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        int i = 0;
        this.type = Type.values()[(Byte)parameters[i++]];
        this.setOrigin((Address)parameters[i++]);
        this.topologyId = (Integer)parameters[i++];
        this.segments = (Set)parameters[i];
    }

    @Override
    public String toString() {
        return "StateRequestCommand{cache=" + this.cacheName + ", origin=" + this.getOrigin() + ", type=" + (Object)((Object)this.type) + ", topologyId=" + this.topologyId + ", segments=" + this.segments + '}';
    }

    public static enum Type {
        GET_TRANSACTIONS,
        GET_CACHE_LISTENERS,
        START_STATE_TRANSFER,
        CANCEL_STATE_TRANSFER;

    }
}

