/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.message.impl.MessageImpl;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.Transformer;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.TypedProperties;
import org.apache.activemq.artemis.utils.UUID;

public class BridgeImpl
implements Bridge,
SessionFailureListener,
SendAcknowledgementHandler {
    private static final boolean isTrace = ActiveMQServerLogger.LOGGER.isTraceEnabled();
    private static final SimpleString JMS_QUEUE_ADDRESS_PREFIX = new SimpleString("jms.queue.");
    private static final SimpleString JMS_TOPIC_ADDRESS_PREFIX = new SimpleString("jms.topic.");
    protected final ServerLocatorInternal serverLocator;
    protected final Executor executor;
    protected final ScheduledExecutorService scheduledExecutor;
    private final ReusableLatch pendingAcks = new ReusableLatch(0);
    private final UUID nodeUUID;
    private final SimpleString name;
    private final Queue queue;
    private final Filter filter;
    private final SimpleString forwardingAddress;
    private final java.util.Queue<MessageReference> refs = new ConcurrentLinkedQueue<MessageReference>();
    private final Transformer transformer;
    private final Object connectionGuard = new Object();
    private final boolean useDuplicateDetection;
    private final String user;
    private final String password;
    private final int reconnectAttempts;
    private final int reconnectAttemptsSameNode;
    private final long retryInterval;
    private final double retryMultiplier;
    private final long maxRetryInterval;
    protected ScheduledFuture<?> futureScheduledReconnection;
    protected volatile ClientSessionInternal session;
    protected String targetNodeID;
    protected TopologyMember targetNode;
    private volatile ClientSessionFactoryInternal csf;
    private volatile ClientProducer producer;
    private volatile boolean started;
    private volatile boolean stopping = false;
    private volatile boolean active;
    private boolean deliveringLargeMessage;
    private int reconnectAttemptsInUse;
    private int retryCount = 0;
    private NotificationService notificationService;
    private boolean keepConnecting = true;

    public BridgeImpl(ServerLocatorInternal serverLocator, int initialConnectAttempts, int reconnectAttempts, int reconnectAttemptsSameNode, long retryInterval, double retryMultiplier, long maxRetryInterval, UUID nodeUUID, SimpleString name, Queue queue, Executor executor, Filter filter, SimpleString forwardingAddress, ScheduledExecutorService scheduledExecutor, Transformer transformer, boolean useDuplicateDetection, String user, String password, StorageManager storageManager) {
        this.reconnectAttempts = reconnectAttempts;
        this.reconnectAttemptsInUse = initialConnectAttempts;
        this.reconnectAttemptsSameNode = reconnectAttemptsSameNode;
        this.retryInterval = retryInterval;
        this.retryMultiplier = retryMultiplier;
        this.maxRetryInterval = maxRetryInterval;
        this.serverLocator = serverLocator;
        this.nodeUUID = nodeUUID;
        this.name = name;
        this.queue = queue;
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
        this.filter = filter;
        this.forwardingAddress = forwardingAddress;
        this.transformer = transformer;
        this.useDuplicateDetection = useDuplicateDetection;
        this.user = user;
        this.password = password;
    }

    public static final byte[] getDuplicateBytes(UUID nodeUUID, long messageID) {
        byte[] bytes = new byte[24];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.put(nodeUUID.asBytes());
        bb.putLong(messageID);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> getDeliveringMessages() {
        BridgeImpl bridgeImpl = this;
        synchronized (bridgeImpl) {
            return new ArrayList<MessageReference>(this.refs);
        }
    }

    private static void cleanUpSessionFactory(ClientSessionFactoryInternal factory) {
        if (factory != null) {
            factory.cleanup();
        }
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.started = true;
        this.stopping = false;
        this.activate();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeUUID.toString(), (NotificationType)CoreNotificationType.BRIDGE_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
    }

    @Override
    public String debug() {
        return this.toString();
    }

    private void cancelRefs() {
        MessageReference ref;
        LinkedList<MessageReference> list = new LinkedList<MessageReference>();
        while ((ref = this.refs.poll()) != null) {
            if (isTrace) {
                ActiveMQServerLogger.LOGGER.trace("Cancelling reference " + ref + " on bridge " + this);
            }
            list.addFirst(ref);
        }
        if (isTrace && list.isEmpty()) {
            ActiveMQServerLogger.LOGGER.trace("didn't have any references to cancel on bridge " + this);
        }
        Queue refqueue = null;
        long timeBase = System.currentTimeMillis();
        for (MessageReference ref2 : list) {
            refqueue = ref2.getQueue();
            try {
                refqueue.cancel(ref2, timeBase);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorCancellingRefOnBridge(e, ref2);
            }
        }
    }

    @Override
    public void flushExecutor() {
        FutureLatch future = new FutureLatch();
        this.executor.execute((Runnable)future);
        boolean ok = future.await(10000L);
        if (!ok) {
            ActiveMQServerLogger.LOGGER.timedOutWaitingToStopBridge();
        }
    }

    @Override
    public void disconnect() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (BridgeImpl.this.session != null) {
                    try {
                        BridgeImpl.this.session.cleanUp(false);
                    }
                    catch (Exception dontcare) {
                        ActiveMQServerLogger.LOGGER.debug(dontcare.getMessage(), dontcare);
                    }
                    BridgeImpl.this.session = null;
                }
            }
        });
    }

    @Override
    public boolean isConnected() {
        return this.session != null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void stop() throws Exception {
        if (this.stopping) {
            return;
        }
        this.stopping = true;
        if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
            ActiveMQServerLogger.LOGGER.debug("Bridge " + this.name + " being stopped");
        }
        if (this.futureScheduledReconnection != null) {
            this.futureScheduledReconnection.cancel(true);
        }
        this.executor.execute(new StopRunnable());
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeUUID.toString(), (NotificationType)CoreNotificationType.BRIDGE_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.broadcastBridgeStoppedError(e);
            }
        }
    }

    @Override
    public void pause() throws Exception {
        if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
            ActiveMQServerLogger.LOGGER.debug("Bridge " + this.name + " being paused");
        }
        this.executor.execute(new PauseRunnable());
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(new SimpleString("name"), this.name);
            Notification notification = new Notification(this.nodeUUID.toString(), (NotificationType)CoreNotificationType.BRIDGE_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.notificationBridgeStoppedError(e);
            }
        }
    }

    @Override
    public void resume() throws Exception {
        this.queue.addConsumer(this);
        this.queue.deliverAsync();
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized void activate() {
        this.executor.execute(new ConnectRunnable(this));
    }

    @Override
    public SimpleString getName() {
        return this.name;
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public SimpleString getForwardingAddress() {
        return this.forwardingAddress;
    }

    @Override
    public RemotingConnection getForwardingConnection() {
        if (this.session == null) {
            return null;
        }
        return this.session.getConnection();
    }

    public void sendAcknowledged(Message message) {
        if (this.active) {
            try {
                MessageReference ref = this.refs.poll();
                if (ref != null) {
                    if (isTrace) {
                        ActiveMQServerLogger.LOGGER.trace(this + " Acking " + ref + " on queue " + ref.getQueue());
                    }
                    ref.getQueue().acknowledge(ref);
                    this.pendingAcks.countDown();
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.bridgeFailedToAck(e);
            }
        }
    }

    protected boolean isPlainCoreBridge() {
        return true;
    }

    protected ServerMessage beforeForward(ServerMessage message) {
        if (this.useDuplicateDetection) {
            byte[] bytes = BridgeImpl.getDuplicateBytes(this.nodeUUID, message.getMessageID());
            message.putBytesProperty(MessageImpl.HDR_BRIDGE_DUPLICATE_ID, bytes);
        }
        if (this.transformer != null) {
            ServerMessage transformedMessage = this.transformer.transform(message);
            if (transformedMessage != message && ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                ActiveMQServerLogger.LOGGER.debug("The transformer " + this.transformer + " made a copy of the message " + message + " as transformedMessage");
            }
            return transformedMessage;
        }
        return message;
    }

    @Override
    public HandleStatus handle(MessageReference ref) throws Exception {
        if (this.filter != null && !this.filter.match(ref.getMessage())) {
            return HandleStatus.NO_MATCH;
        }
        BridgeImpl bridgeImpl = this;
        synchronized (bridgeImpl) {
            if (!this.active) {
                if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQServerLogger.LOGGER.debug(this + "::Ignoring reference on bridge as it is set to inactive ref=" + ref);
                }
                return HandleStatus.BUSY;
            }
            if (this.deliveringLargeMessage) {
                return HandleStatus.BUSY;
            }
            if (isTrace) {
                ActiveMQServerLogger.LOGGER.trace("Bridge " + this + " is handling reference=" + ref);
            }
            ref.handled();
            this.refs.add(ref);
            ServerMessage message = this.beforeForward(ref.getMessage());
            SimpleString dest = this.forwardingAddress != null ? this.forwardingAddress : message.getAddress();
            this.pendingAcks.countUp();
            try {
                if (message.isLargeMessage()) {
                    this.deliveringLargeMessage = true;
                    this.deliverLargeMessage(dest, ref, (LargeServerMessage)message);
                    return HandleStatus.HANDLED;
                }
                return this.deliverStandardMessage(dest, ref, message);
            }
            catch (Exception e) {
                this.pendingAcks.countDown();
                throw e;
            }
        }
    }

    @Override
    public void proceedDeliver(MessageReference ref) {
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver) {
        this.connectionFailed(me, failedOver, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
        ActiveMQServerLogger.LOGGER.bridgeConnectionFailed((Exception)((Object)me), failedOver);
        Object object = this.connectionGuard;
        synchronized (object) {
            this.keepConnecting = true;
        }
        try {
            if (this.producer != null) {
                this.producer.close();
            }
            BridgeImpl.cleanUpSessionFactory(this.csf);
        }
        catch (Throwable dontCare) {
            // empty catch block
        }
        try {
            this.session.cleanUp(false);
        }
        catch (Throwable dontCare) {
            // empty catch block
        }
        if (scaleDownTargetNodeID != null && !scaleDownTargetNodeID.equals(this.nodeUUID.toString())) {
            object = this;
            synchronized (object) {
                try {
                    ActiveMQServerLogger.LOGGER.debug("Moving " + this.queue.getMessageCount() + " messages from " + this.queue.getName() + " to " + scaleDownTargetNodeID);
                    ((QueueImpl)this.queue).moveReferencesBetweenSnFQueues(SimpleString.toSimpleString((String)scaleDownTargetNodeID));
                    this.fail(true);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
                }
            }
        }
        if (scaleDownTargetNodeID != null) {
            ActiveMQServerLogger.LOGGER.debug("Received scaleDownTargetNodeID: " + scaleDownTargetNodeID + "; cancelling reconnect.");
            this.fail(true);
        } else {
            ActiveMQServerLogger.LOGGER.debug("Received invalid scaleDownTargetNodeID: " + scaleDownTargetNodeID);
            this.fail(me.getType() == ActiveMQExceptionType.DISCONNECTED);
        }
        this.tryScheduleRetryReconnect(me.getType());
    }

    protected void tryScheduleRetryReconnect(ActiveMQExceptionType type) {
        this.scheduleRetryConnect();
    }

    public void beforeReconnect(ActiveMQException exception) {
    }

    private void deliverLargeMessage(final SimpleString dest, final MessageReference ref, final LargeServerMessage message) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BridgeImpl.this.producer.send(dest, (Message)message);
                    BridgeImpl.this.unsetLargeMessageDelivery();
                    if (BridgeImpl.this.queue != null) {
                        BridgeImpl.this.queue.deliverAsync();
                    }
                }
                catch (ActiveMQException e) {
                    BridgeImpl.this.unsetLargeMessageDelivery();
                    ActiveMQServerLogger.LOGGER.bridgeUnableToSendMessage((Exception)((Object)e), ref);
                    BridgeImpl.this.connectionFailed(e, false);
                }
            }
        });
    }

    private HandleStatus deliverStandardMessage(SimpleString dest, MessageReference ref, ServerMessage message) {
        if (ActiveMQServerLogger.LOGGER.isTraceEnabled()) {
            ActiveMQServerLogger.LOGGER.trace("going to send message: " + message + " from " + this.getQueue());
        }
        try {
            this.producer.send(dest, (Message)message);
        }
        catch (ActiveMQException e) {
            ActiveMQServerLogger.LOGGER.bridgeUnableToSendMessage((Exception)((Object)e), ref);
            this.refs.remove(ref);
            this.connectionFailed(e, false);
            return HandleStatus.BUSY;
        }
        return HandleStatus.HANDLED;
    }

    public TopologyMember getTargetNodeFromTopology() {
        return this.targetNode;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " [name=" + this.name + ", queue=" + this.queue + " targetConnector=" + this.serverLocator + "]";
    }

    @Override
    public String toManagementString() {
        return this.getClass().getSimpleName() + " [name=" + this.name + ", queue=" + this.queue.getName() + "/" + this.queue.getID() + "]";
    }

    public ClientSessionFactoryImpl getCSF() {
        return (ClientSessionFactoryImpl)this.csf;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    protected void fail(boolean permanently) {
        ActiveMQServerLogger.LOGGER.debug(this + "\n\t::fail being called, permanently=" + permanently);
        if (this.queue != null) {
            try {
                if (isTrace) {
                    ActiveMQServerLogger.LOGGER.trace("Removing consumer on fail " + this + " from queue " + this.queue);
                }
                this.queue.removeConsumer(this);
            }
            catch (Exception dontcare) {
                ActiveMQServerLogger.LOGGER.debug(dontcare);
            }
        }
        this.cancelRefs();
        if (this.queue != null) {
            this.queue.deliverAsync();
        }
    }

    protected void afterConnect() throws Exception {
        this.retryCount = 0;
        this.reconnectAttemptsInUse = this.reconnectAttempts;
        if (this.futureScheduledReconnection != null) {
            this.futureScheduledReconnection.cancel(true);
            this.futureScheduledReconnection = null;
        }
    }

    protected ClientSessionFactoryInternal createSessionFactory() throws Exception {
        if (this.targetNodeID != null && (this.reconnectAttemptsSameNode < 0 || this.retryCount <= this.reconnectAttemptsSameNode)) {
            this.csf = this.reconnectOnOriginalNode();
        } else {
            this.serverLocator.resetToInitialConnectors();
            this.csf = (ClientSessionFactoryInternal)this.serverLocator.createSessionFactory();
        }
        if (this.csf != null) {
            this.csf.setReconnectAttempts(0);
        }
        return this.csf;
    }

    private ClientSessionFactoryInternal reconnectOnOriginalNode() throws Exception {
        String targetNodeIdUse = this.targetNodeID;
        TopologyMember nodeUse = this.targetNode;
        if (targetNodeIdUse != null && nodeUse != null) {
            TransportConfiguration[] configs = new TransportConfiguration[2];
            int numberOfConfigs = 0;
            if (nodeUse.getLive() != null) {
                configs[numberOfConfigs++] = nodeUse.getLive();
            }
            if (nodeUse.getBackup() != null) {
                configs[numberOfConfigs++] = nodeUse.getBackup();
            }
            if (numberOfConfigs > 0) {
                int nodeTry = (this.retryCount - 1) % numberOfConfigs;
                return (ClientSessionFactoryInternal)this.serverLocator.createSessionFactory(configs[nodeTry]);
            }
        }
        return null;
    }

    protected void setSessionFactory(ClientSessionFactoryInternal sfi) {
        this.csf = sfi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect() {
        if (this.stopping) {
            return;
        }
        Object object = this.connectionGuard;
        synchronized (object) {
            if (!this.keepConnecting) {
                return;
            }
            ActiveMQServerLogger.LOGGER.debug("Connecting  " + this + " to its destination [" + this.nodeUUID.toString() + "], csf=" + this.csf);
            ++this.retryCount;
            try {
                if (this.csf == null || this.csf.isClosed()) {
                    if (this.stopping) {
                        return;
                    }
                    this.csf = this.createSessionFactory();
                    if (this.csf == null) {
                        this.scheduleRetryConnect();
                        return;
                    }
                    this.session = (ClientSessionInternal)this.csf.createSession(this.user, this.password, false, true, true, true, 1);
                }
                if (this.forwardingAddress != null) {
                    ClientSession.AddressQuery query = null;
                    try {
                        query = this.session.addressQuery(this.forwardingAddress);
                    }
                    catch (Throwable e) {
                        ActiveMQServerLogger.LOGGER.errorQueryingBridge(e, this.name);
                        --this.retryCount;
                        this.scheduleRetryConnectFixedTimeout(100L);
                        return;
                    }
                    if (this.forwardingAddress.startsWith(JMS_QUEUE_ADDRESS_PREFIX) || this.forwardingAddress.startsWith(JMS_TOPIC_ADDRESS_PREFIX)) {
                        if (!query.isExists()) {
                            ActiveMQServerLogger.LOGGER.errorQueryingBridge(this.forwardingAddress, this.retryCount);
                            this.scheduleRetryConnect();
                            return;
                        }
                    } else if (!query.isExists()) {
                        ActiveMQServerLogger.LOGGER.bridgeNoBindings(this.getName(), this.getForwardingAddress(), this.getForwardingAddress());
                    }
                }
                this.producer = this.session.createProducer();
                this.session.addFailureListener((SessionFailureListener)this);
                this.session.setSendAcknowledgementHandler((SendAcknowledgementHandler)this);
                this.afterConnect();
                this.active = true;
                this.queue.addConsumer(this);
                this.queue.deliverAsync();
                ActiveMQServerLogger.LOGGER.bridgeConnected(this);
                if (this.isPlainCoreBridge()) {
                    this.serverLocator.addClusterTopologyListener((ClusterTopologyListener)new TopologyListener());
                }
                this.keepConnecting = false;
                return;
            }
            catch (ActiveMQException e) {
                if (e.getType() == ActiveMQExceptionType.SESSION_CREATION_REJECTED) {
                    ActiveMQServerLogger.LOGGER.errorStartingBridge(this.name);
                    --this.retryCount;
                    this.scheduleRetryConnectFixedTimeout(this.retryInterval);
                    return;
                }
                if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                    ActiveMQServerLogger.LOGGER.debug("Bridge " + this + " is unable to connect to destination. Retrying", e);
                }
                this.scheduleRetryConnect();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorConnectingBridge(e, this);
            }
        }
    }

    protected void scheduleRetryConnect() {
        if (this.serverLocator.isClosed()) {
            ActiveMQServerLogger.LOGGER.bridgeLocatorShutdown();
            return;
        }
        if (this.stopping) {
            ActiveMQServerLogger.LOGGER.bridgeStopping();
            return;
        }
        if (this.reconnectAttemptsInUse >= 0 && this.retryCount > this.reconnectAttemptsInUse) {
            ActiveMQServerLogger.LOGGER.bridgeAbortStart(this.name, this.retryCount, this.reconnectAttempts);
            this.fail(true);
            return;
        }
        long timeout = (long)((double)this.retryInterval * Math.pow(this.retryMultiplier, this.retryCount));
        if (timeout == 0L) {
            timeout = this.retryInterval;
        }
        if (timeout > this.maxRetryInterval) {
            timeout = this.maxRetryInterval;
        }
        ActiveMQServerLogger.LOGGER.debug("Bridge " + this + " retrying connection #" + this.retryCount + ", maxRetry=" + this.reconnectAttemptsInUse + ", timeout=" + timeout);
        this.scheduleRetryConnectFixedTimeout(timeout);
    }

    protected void scheduleRetryConnectFixedTimeout(long milliseconds) {
        try {
            BridgeImpl.cleanUpSessionFactory(this.csf);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.stopping) {
            return;
        }
        if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
            ActiveMQServerLogger.LOGGER.debug("Scheduling retry for bridge " + this.name + " in " + milliseconds + " milliseconds");
        }
        this.futureScheduledReconnection = this.scheduledExecutor.schedule(new FutureConnectRunnable(this.executor, this), milliseconds, TimeUnit.MILLISECONDS);
    }

    private void internalCancelReferences() {
        this.cancelRefs();
        if (this.queue != null) {
            this.queue.deliverAsync();
        }
    }

    private synchronized void unsetLargeMessageDelivery() {
        this.deliveringLargeMessage = false;
    }

    private class TopologyListener
    implements ClusterTopologyListener {
        private TopologyListener() {
        }

        public void nodeUP(TopologyMember member, boolean last) {
            RemotingConnection connectionToUse;
            ClientSessionInternal sessionToUse = BridgeImpl.this.session;
            RemotingConnection remotingConnection = connectionToUse = sessionToUse != null ? sessionToUse.getConnection() : null;
            if (member != null && BridgeImpl.this.targetNodeID != null && BridgeImpl.this.targetNodeID.equals(member.getNodeId())) {
                BridgeImpl.this.targetNode = member;
            } else if (connectionToUse != null && member.isMember(connectionToUse)) {
                BridgeImpl.this.targetNode = member;
                BridgeImpl.this.targetNodeID = member.getNodeId();
            }
        }

        public void nodeDown(long eventUID, String nodeID) {
        }
    }

    private class PauseRunnable
    implements Runnable {
        private PauseRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BridgeImpl.this.queue.removeConsumer(BridgeImpl.this);
                if (!BridgeImpl.this.pendingAcks.await(60L, TimeUnit.SECONDS)) {
                    ActiveMQServerLogger.LOGGER.timedOutWaitingCompletions(BridgeImpl.this.toString(), BridgeImpl.this.pendingAcks.getCount());
                }
                BridgeImpl bridgeImpl = BridgeImpl.this;
                synchronized (bridgeImpl) {
                    BridgeImpl.this.started = false;
                    BridgeImpl.this.active = false;
                }
                BridgeImpl.this.internalCancelReferences();
                ActiveMQServerLogger.LOGGER.bridgePaused(BridgeImpl.this.name);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorPausingBridge(e);
            }
        }
    }

    private class StopRunnable
    implements Runnable {
        private StopRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ActiveMQServerLogger.LOGGER.debug("stopping bridge " + BridgeImpl.this);
                BridgeImpl.this.queue.removeConsumer(BridgeImpl.this);
                if (!BridgeImpl.this.pendingAcks.await(10L, TimeUnit.SECONDS)) {
                    ActiveMQServerLogger.LOGGER.timedOutWaitingCompletions(BridgeImpl.this.toString(), BridgeImpl.this.pendingAcks.getCount());
                }
                BridgeImpl bridgeImpl = BridgeImpl.this;
                synchronized (bridgeImpl) {
                    ActiveMQServerLogger.LOGGER.debug("Closing Session for bridge " + BridgeImpl.this.name);
                    BridgeImpl.this.started = false;
                    BridgeImpl.this.active = false;
                }
                BridgeImpl.this.internalCancelReferences();
                if (BridgeImpl.this.session != null) {
                    ActiveMQServerLogger.LOGGER.debug("Cleaning up session " + BridgeImpl.this.session);
                    BridgeImpl.this.session.removeFailureListener((SessionFailureListener)BridgeImpl.this);
                    try {
                        BridgeImpl.this.session.close();
                        BridgeImpl.this.session = null;
                    }
                    catch (ActiveMQException dontcare) {
                        // empty catch block
                    }
                }
                if (BridgeImpl.this.csf != null) {
                    BridgeImpl.this.csf.cleanup();
                }
                Object dontcare = BridgeImpl.this.connectionGuard;
                synchronized (dontcare) {
                    BridgeImpl.this.keepConnecting = true;
                }
                if (isTrace) {
                    ActiveMQServerLogger.LOGGER.trace("Removing consumer on stopRunnable " + this + " from queue " + BridgeImpl.this.queue);
                }
                ActiveMQServerLogger.LOGGER.bridgeStopped(BridgeImpl.this.name);
            }
            catch (RuntimeException e) {
                ActiveMQServerLogger.LOGGER.error("Failed to stop bridge", e);
            }
            catch (InterruptedException e) {
                ActiveMQServerLogger.LOGGER.error("Failed to stop bridge", e);
            }
        }
    }

    private static final class ConnectRunnable
    implements Runnable {
        private final BridgeImpl bridge;

        public ConnectRunnable(BridgeImpl bridge2) {
            this.bridge = bridge2;
        }

        @Override
        public void run() {
            this.bridge.connect();
        }
    }

    private static class FutureConnectRunnable
    implements Runnable {
        private final BridgeImpl bridge;
        private final Executor executor;

        public FutureConnectRunnable(Executor exe, BridgeImpl bridge) {
            this.executor = exe;
            this.bridge = bridge;
        }

        @Override
        public void run() {
            if (this.bridge.isStarted()) {
                this.executor.execute(new ConnectRunnable(this.bridge));
            }
        }
    }
}

