/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AsciiString;
import org.jgroups.util.Buffer;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

@MBean(description="Protocol which encrypts and decrypts cluster traffic")
public class ENCRYPT
extends Protocol {
    private static final String DEFAULT_SYM_ALGO = "AES";
    Address local_addr;
    Address keyServerAddr;
    boolean keyServer = false;
    @Property(name="asym_provider", description="Cryptographic Service Provider. Default is Bouncy Castle Provider")
    String asymProvider = null;
    @Property(name="sym_provider", description="Cryptographic Service Provider. Default is Bouncy Castle Provider")
    String symProvider = null;
    @Property(name="asym_algorithm", description="Cipher engine transformation for asymmetric algorithm. Default is RSA")
    protected String asymAlgorithm = "RSA";
    @Property(name="sym_algorithm", description="Cipher engine transformation for symmetric algorithm. Default is AES")
    String symAlgorithm = "AES";
    @Property(name="asym_init", description="Initial public/private key length. Default is 512")
    int asymInit = 512;
    @Property(name="sym_init", description="Initial key length for matching symmetric algorithm. Default is 128")
    int symInit = 128;
    @Property(name="change_keys", description="Generate new symmetric keys on every view change. Default is false. Set this to true when using asymmetric encryption, to handle merging (JGRP-1907)")
    boolean changeKeysOnViewChange = false;
    private boolean suppliedKey = false;
    @Property(name="key_store_name", description="File on classpath that contains keystore repository")
    String keyStoreName;
    @Property(name="store_password", description="Password used to check the integrity/unlock the keystore. Change the default", exposeAsManagedAttribute=false)
    private String storePassword = "changeit";
    @Property(name="key_password", description="Password for recovering the key. Change the default", exposeAsManagedAttribute=false)
    private String keyPassword = null;
    @Property(name="alias", description="Alias used for recovering the key. Change the default", exposeAsManagedAttribute=false)
    private String alias = "mykey";
    @Property(description="Number of ciphers in the pool to parallelize encrypt and decrypt requests", writable=false)
    protected int cipher_pool_size = 8;
    KeyPair Kpair;
    PublicKey serverPubKey = null;
    protected Cipher[] encoding_ciphers;
    protected Cipher[] decoding_ciphers;
    protected Lock[] encoding_locks;
    protected Lock[] decoding_locks;
    protected final AtomicInteger cipher_index = new AtomicInteger(0);
    protected byte[] symVersion;
    protected SecretKey secretKey;
    final Map<AsciiString, Cipher> keyMap = new WeakHashMap<AsciiString, Cipher>();
    private boolean queue_up = true;
    private boolean queue_down = false;
    private BlockingQueue<Message> upMessageQueue = new LinkedBlockingQueue<Message>();
    private BlockingQueue<Message> downMessageQueue = new LinkedBlockingQueue<Message>();
    private Cipher asymCipher;
    @Property
    private boolean encrypt_entire_message = false;

    protected int getNextIndex() {
        int current_index = this.cipher_index.getAndIncrement();
        return current_index & this.cipher_pool_size - 1;
    }

    public int getAsymInit() {
        return this.asymInit;
    }

    public SecretKey getDesKey() {
        return this.secretKey;
    }

    public KeyPair getKpair() {
        return this.Kpair;
    }

    public Cipher getAsymCipher() {
        return this.asymCipher;
    }

    public String getSymAlgorithm() {
        return this.symAlgorithm;
    }

    public int getSymInit() {
        return this.symInit;
    }

    public String getAsymAlgorithm() {
        return this.asymAlgorithm;
    }

    public byte[] getSymVersion() {
        return this.symVersion;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getSymDecodingCipher() {
        return this.decoding_ciphers[this.getNextIndex()];
    }

    public Cipher getSymEncodingCipher() {
        return this.encoding_ciphers[this.getNextIndex()];
    }

    public Address getKeyServerAddr() {
        return this.keyServerAddr;
    }

    private void setSymVersion(byte[] symVersion) {
        this.symVersion = Arrays.copyOf(symVersion, symVersion.length);
    }

    private void setSecretKey(SecretKey secretKey) {
        this.secretKey = secretKey;
    }

    protected void setLocalAddress(Address local_addr) {
        this.local_addr = local_addr;
    }

    protected void setKeyServerAddr(Address keyServerAddr) {
        this.keyServerAddr = keyServerAddr;
    }

    private static String getAlgorithm(String s) {
        int index = s.indexOf("/");
        if (index == -1) {
            return s;
        }
        return s.substring(0, index);
    }

    @Override
    public void init() throws Exception {
        int tmp;
        if (this.keyPassword == null && this.storePassword != null) {
            this.keyPassword = this.storePassword;
            this.log.debug("key_password used is same as store_password");
        }
        if (this.keyStoreName == null) {
            this.initSymKey();
            this.initKeyPair();
        } else {
            this.initConfiguredKey();
        }
        if (this.cipher_pool_size <= 0) {
            this.log.warn("cipher_pool_size of %d is invalid; setting it to 1", this.cipher_pool_size);
            this.cipher_pool_size = 1;
        }
        if ((tmp = Util.getNextHigherPowerOfTwo(this.cipher_pool_size)) != this.cipher_pool_size) {
            this.log.warn("setting cipher_pool_size (%d) to %d (power of 2) for faster modulo operation", this.cipher_pool_size, tmp);
            this.cipher_pool_size = tmp;
        }
        this.encoding_ciphers = new Cipher[this.cipher_pool_size];
        this.encoding_locks = new Lock[this.cipher_pool_size];
        this.decoding_ciphers = new Cipher[this.cipher_pool_size];
        this.decoding_locks = new Lock[this.cipher_pool_size];
        this.initSymCiphers(this.symAlgorithm, this.getSecretKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfiguredKey() throws Exception {
        InputStream inputStream = null;
        KeyStore store = KeyStore.getInstance("JCEKS");
        SecretKey tempKey = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.keyStoreName);
            if (inputStream == null) {
                inputStream = new FileInputStream(this.keyStoreName);
            }
            if (inputStream == null) {
                throw new Exception("Unable to load keystore " + this.keyStoreName + " ensure file is on classpath");
            }
            try {
                store.load(inputStream, this.storePassword.toCharArray());
                tempKey = (SecretKey)store.getKey(this.alias, this.keyPassword.toCharArray());
            }
            catch (IOException e) {
                throw new Exception("Unable to load keystore " + this.keyStoreName + ": " + e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new Exception("No Such algorithm " + this.keyStoreName + ": " + e);
            }
            catch (CertificateException e) {
                throw new Exception("Certificate exception " + this.keyStoreName + ": " + e);
            }
            if (tempKey == null) {
                throw new Exception("Unable to retrieve key '" + this.alias + "' from keystore " + this.keyStoreName);
            }
            this.setSecretKey(tempKey);
            if (this.symAlgorithm.equals(DEFAULT_SYM_ALGO)) {
                this.symAlgorithm = tempKey.getAlgorithm();
            }
            this.suppliedKey = true;
            this.queue_up = false;
            this.queue_down = false;
        }
        catch (Throwable throwable) {
            Util.close(inputStream);
            throw throwable;
        }
        Util.close((Closeable)inputStream);
    }

    public void initSymKey() throws Exception {
        KeyGenerator keyGen = null;
        keyGen = this.symProvider != null && !this.symProvider.trim().isEmpty() ? KeyGenerator.getInstance(ENCRYPT.getAlgorithm(this.symAlgorithm), this.symProvider) : KeyGenerator.getInstance(ENCRYPT.getAlgorithm(this.symAlgorithm));
        keyGen.init(this.symInit);
        this.secretKey = keyGen.generateKey();
        this.setSecretKey(this.secretKey);
        this.log.debug("symmetric key generated ");
    }

    private void initSymCiphers(String algorithm, SecretKey secret) throws Exception {
        this.log.debug("initializing symmetric ciphers (pool size=%d)", this.cipher_pool_size);
        for (int i = 0; i < this.cipher_pool_size; ++i) {
            this.encoding_ciphers[i] = this.symProvider != null && !this.symProvider.trim().isEmpty() ? Cipher.getInstance(algorithm, this.symProvider) : Cipher.getInstance(algorithm);
            this.encoding_ciphers[i].init(1, secret);
            this.decoding_ciphers[i] = this.symProvider != null && !this.symProvider.trim().isEmpty() ? Cipher.getInstance(algorithm, this.symProvider) : Cipher.getInstance(algorithm);
            this.decoding_ciphers[i].init(2, secret);
            this.encoding_locks[i] = new ReentrantLock();
            this.decoding_locks[i] = new ReentrantLock();
        }
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.reset();
        digest.update(secret.getEncoded());
        byte[] tmp = digest.digest();
        this.symVersion = Arrays.copyOf(tmp, tmp.length);
        this.log.debug("initialized symmetric ciphers with secret key (" + this.symVersion.length + " bytes)");
    }

    public void initKeyPair() throws Exception {
        KeyPairGenerator KpairGen = null;
        KpairGen = this.asymProvider != null && !this.asymProvider.trim().isEmpty() ? KeyPairGenerator.getInstance(ENCRYPT.getAlgorithm(this.asymAlgorithm), this.asymProvider) : KeyPairGenerator.getInstance(ENCRYPT.getAlgorithm(this.asymAlgorithm));
        KpairGen.initialize(this.asymInit, new SecureRandom());
        this.Kpair = KpairGen.generateKeyPair();
        this.asymCipher = this.asymProvider != null && !this.asymProvider.trim().isEmpty() ? Cipher.getInstance(this.asymAlgorithm, this.asymProvider) : Cipher.getInstance(this.asymAlgorithm);
        this.asymCipher.init(2, this.Kpair.getPrivate());
        this.log.debug("asym algo initialized");
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View view = (View)evt.getArg();
                this.log.debug("new view: " + view);
                if (this.suppliedKey) break;
                this.handleViewChange(view, false);
                break;
            }
            case 15: {
                View view = (View)evt.getArg();
                if (this.suppliedKey) break;
                this.handleViewChange(view, true);
                break;
            }
            case 1: {
                try {
                    return this.handleUpMessage(evt);
                }
                catch (Exception e) {
                    this.log.warn("exception occurred decrypting message", e);
                    return null;
                }
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        Decrypter decrypter = new Decrypter();
        batch.map(decrypter);
        decrypter.unlock();
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    private synchronized void handleViewChange(View view, boolean makeServer) {
        List<Address> members;
        if (makeServer) {
            this.initializeNewSymmetricKey(view instanceof MergeView);
        }
        if ((members = view.getMembers()) == null || members.isEmpty() || members.get(0) == null) {
            this.becomeKeyServer(this.local_addr, false);
            return;
        }
        Address tmpKeyServer = view.getMembers().get(0);
        if (makeServer || tmpKeyServer.equals(this.local_addr)) {
            this.becomeKeyServer(tmpKeyServer, makeServer);
        } else {
            this.handleNewKeyServer(tmpKeyServer, view instanceof MergeView);
        }
    }

    private void initializeNewSymmetricKey(boolean merge_view) {
        try {
            if (this.changeKeysOnViewChange || !this.keyServer || merge_view) {
                this.log.debug("initalizing new ciphers");
                this.initSymKey();
                this.initSymCiphers(this.getSymAlgorithm(), this.getSecretKey());
            }
        }
        catch (Exception e) {
            this.log.error("could not initialize new ciphers", e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
    }

    private void becomeKeyServer(Address tmpKeyServer, boolean forced) {
        this.keyServerAddr = tmpKeyServer;
        this.keyServer = true;
        if (this.log.isDebugEnabled() && !forced) {
            this.log.debug("%s: I have become the new key server", this.local_addr);
        }
        this.queue_down = false;
        this.queue_up = false;
    }

    private void handleNewKeyServer(Address newKeyServer, boolean merge_view) {
        if (this.changeKeysOnViewChange || this.keyServerChanged(newKeyServer) || merge_view) {
            this.queue_up = true;
            this.queue_down = true;
            this.keyServerAddr = newKeyServer;
            this.keyServer = false;
            this.log.debug("%s: %s has become the new key server, sending key request to it", this.local_addr, this.keyServerAddr);
            this.sendKeyRequest();
        }
    }

    private boolean keyServerChanged(Address newKeyServer) {
        return this.keyServerAddr == null || !this.keyServerAddr.equals(newKeyServer);
    }

    private Object handleUpMessage(Event evt) throws Exception {
        EncryptHeader hdr;
        Message msg = (Message)evt.getArg();
        if (msg == null || msg.getLength() == 0 && !this.encrypt_entire_message || (hdr = (EncryptHeader)msg.getHeader(this.id)) == null) {
            return this.up_prot.up(evt);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("header received %s", hdr);
        }
        switch (hdr.getType()) {
            case 1: {
                return this.handleEncryptedMessage(msg, evt, hdr);
            }
        }
        this.handleUpEvent(msg, hdr);
        return null;
    }

    protected Object handleEncryptedMessage(Message msg, Event evt, EncryptHeader hdr) throws Exception {
        Message tmpMsg;
        if (this.queue_up) {
            this.log.trace("queueing up message as no session key established: %s", msg);
            this.upMessageQueue.put(msg);
            return null;
        }
        if (!this.suppliedKey) {
            this.drainUpQueue();
        }
        if ((tmpMsg = this.decryptMessage(null, msg.copy())) != null) {
            return this.up_prot.up(new Event(1, tmpMsg));
        }
        this.log.warn("unrecognised cipher; discarding message");
        return null;
    }

    protected void handleUpEvent(Message msg, EncryptHeader hdr) {
        if (this.suppliedKey) {
            this.log.warn("we received an encrypt header of %s while in configured mode", hdr.getType());
            return;
        }
        switch (hdr.getType()) {
            case 2: {
                this.log.debug("received a key request from peer %s", msg.getSrc());
                try {
                    PublicKey tmpKey = this.generatePubKey(msg.getBuffer());
                    this.sendSecretKey(this.getSecretKey(), tmpKey, msg.getSrc());
                }
                catch (Exception e) {
                    this.log.warn("unable to reconstitute peer's public key");
                }
                break;
            }
            case 4: {
                this.log.debug("received a secretkey response from keyserver %s", msg.getSrc());
                try {
                    SecretKeySpec tmp = this.decodeKey(msg.getBuffer());
                    if (tmp == null) {
                        this.sendKeyRequest();
                        break;
                    }
                    this.setKeys(tmp, hdr.getVersion());
                    this.log.debug("decoded secretkey response");
                }
                catch (Exception e) {
                    this.log.warn("unable to process received public key", e);
                }
                break;
            }
            default: {
                this.log.warn("received ignored encrypt header of %s", hdr.getType());
            }
        }
    }

    private void drainUpQueue() {
        int size;
        if (this.log.isTraceEnabled() && (size = this.upMessageQueue.size()) > 0) {
            this.log.trace("draining %d messages from the up queue", size);
        }
        while (true) {
            try {
                Message tmp;
                while ((tmp = this.upMessageQueue.poll(0L, TimeUnit.MILLISECONDS)) != null) {
                    Message msg = this.decryptMessage(null, tmp.copy());
                    if (msg == null) continue;
                    this.up_prot.up(new Event(1, msg));
                }
            }
            catch (Throwable t) {
                this.log.error("failed decrypting and sending message up when draining queue", t);
                continue;
            }
            break;
        }
    }

    private void drainDownQueue() {
        int size;
        if (this.log.isTraceEnabled() && (size = this.downMessageQueue.size()) > 0) {
            this.log.trace("draining %d messages from the down queue", size);
        }
        while (true) {
            try {
                Message tmp;
                while ((tmp = this.downMessageQueue.poll(0L, TimeUnit.MILLISECONDS)) != null) {
                    this.encryptAndSend(tmp);
                }
            }
            catch (Throwable t) {
                this.log.error("failed sending message down when draining queue", t);
                continue;
            }
            break;
        }
    }

    private void setKeys(SecretKey key, byte[] version) throws Exception {
        this.keyMap.put(new AsciiString(this.getSymVersion()), this.getSymDecodingCipher());
        this.setSecretKey(key);
        this.initSymCiphers(key.getAlgorithm(), key);
        this.setSymVersion(version);
        this.log.debug("setting queue up to false in setKeys");
        this.queue_up = false;
        this.drainUpQueue();
        this.queue_down = false;
        this.drainDownQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message decryptMessage(Cipher cipher, Message msg) throws Exception {
        EncryptHeader hdr = (EncryptHeader)msg.getHeader(this.id);
        if (!Arrays.equals(hdr.getVersion(), this.getSymVersion())) {
            this.log.warn("attempting to use stored cipher as message does not use current encryption version ");
            cipher = this.keyMap.get(new AsciiString(hdr.getVersion()));
            if (cipher == null) {
                this.log.warn("unable to find a matching cipher in previous key map");
                return null;
            }
            this.log.trace("decrypting using previous cipher version");
            Cipher cipher2 = cipher;
            synchronized (cipher2) {
                return this._decrypt(cipher, msg, hdr.encryptEntireMessage());
            }
        }
        return this._decrypt(cipher, msg, hdr.encryptEntireMessage());
    }

    private Message _decrypt(Cipher cipher, Message msg, boolean decrypt_entire_msg) throws Exception {
        byte[] decrypted_msg = cipher == null ? this.code(msg.getRawBuffer(), msg.getOffset(), msg.getLength(), true) : cipher.doFinal(msg.getRawBuffer(), msg.getOffset(), msg.getLength());
        if (!decrypt_entire_msg) {
            msg.setBuffer(decrypted_msg);
            return msg;
        }
        Message ret = Util.streamableFromBuffer(Message.class, decrypted_msg, 0, decrypted_msg.length);
        if (ret.getDest() == null) {
            ret.setDest(msg.getDest());
        }
        if (ret.getSrc() == null) {
            ret.setSrc(msg.getSrc());
        }
        return ret;
    }

    private void sendSecretKey(SecretKey secret, PublicKey pubKey, Address source) throws Exception {
        Cipher tmp = this.asymProvider != null && !this.asymProvider.trim().isEmpty() ? Cipher.getInstance(this.asymAlgorithm, this.asymProvider) : Cipher.getInstance(this.asymAlgorithm);
        tmp.init(1, pubKey);
        byte[] encryptedKey = tmp.doFinal(secret.getEncoded());
        Message newMsg = new Message(source, this.local_addr, encryptedKey).putHeader(this.id, new EncryptHeader(4, this.getSymVersion()));
        this.log.debug("sending version %s encoded key to client", new String(this.getSymVersion()));
        this.down_prot.down(new Event(1, newMsg));
    }

    private void sendKeyRequest() {
        Message newMsg = new Message(this.keyServerAddr, this.local_addr, this.Kpair.getPublic().getEncoded()).putHeader(this.id, new EncryptHeader(2, this.getSymVersion()));
        this.down_prot.down(new Event(1, newMsg));
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg.getLength() == 0 && !this.encrypt_entire_message) break;
                try {
                    if (this.queue_down) {
                        this.log.trace("queueing down message as no session key established: %s", msg);
                        this.downMessageQueue.put(msg);
                    } else {
                        if (!this.suppliedKey) {
                            this.drainDownQueue();
                        }
                        this.encryptAndSend(msg);
                    }
                }
                catch (Exception e) {
                    this.log.warn("unable to send message down", e);
                }
                return null;
            }
            case 6: {
                View view = (View)evt.getArg();
                this.log.debug("new view: " + view);
                if (this.suppliedKey) break;
                this.handleViewChange(view, false);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                this.log.debug("set local address to %s", this.local_addr);
                break;
            }
            case 15: {
                View view = (View)evt.getArg();
                if (this.suppliedKey) break;
                this.handleViewChange(view, true);
            }
        }
        return this.down_prot.down(evt);
    }

    private void encryptAndSend(Message msg) throws Exception {
        EncryptHeader hdr = new EncryptHeader(1, this.getSymVersion());
        if (this.encrypt_entire_message) {
            hdr.type = (byte)(hdr.type | 8);
        }
        if (this.encrypt_entire_message) {
            if (msg.getSrc() == null) {
                msg.setSrc(this.local_addr);
            }
            Buffer serialized_msg = Util.streamableToBuffer(msg);
            byte[] encrypted_msg = this.code(serialized_msg.getBuf(), serialized_msg.getOffset(), serialized_msg.getLength(), false);
            Message tmp = msg.copy(false, false).setBuffer(encrypted_msg).putHeader(this.id, hdr);
            this.down_prot.down(new Event(1, tmp));
            return;
        }
        Message msgEncrypted = msg.copy(false).putHeader(this.id, hdr).setBuffer(this.code(msg.getRawBuffer(), msg.getOffset(), msg.getLength(), false));
        this.down_prot.down(new Event(1, msgEncrypted));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] code(byte[] buf, int offset, int length, boolean decode) throws Exception {
        int index = this.getNextIndex();
        Lock lock = decode ? this.decoding_locks[index] : this.encoding_locks[index];
        Cipher cipher = decode ? this.decoding_ciphers[index] : this.encoding_ciphers[index];
        lock.lock();
        try {
            byte[] byArray = cipher.doFinal(buf, offset, length);
            return byArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretKeySpec decodeKey(byte[] encodedKey) throws Exception {
        byte[] keyBytes;
        ENCRYPT eNCRYPT = this;
        synchronized (eNCRYPT) {
            keyBytes = this.asymCipher.doFinal(encodedKey);
        }
        try {
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, ENCRYPT.getAlgorithm(this.symAlgorithm));
            Cipher temp = this.symProvider != null && !this.symProvider.trim().isEmpty() ? Cipher.getInstance(this.symAlgorithm, this.symProvider) : Cipher.getInstance(this.symAlgorithm);
            temp.init(3, keySpec);
            return keySpec;
        }
        catch (Exception e) {
            this.log.error("failed decoding key", e);
            return null;
        }
    }

    private PublicKey generatePubKey(byte[] encodedKey) {
        PublicKey pubKey = null;
        try {
            KeyFactory KeyFac = KeyFactory.getInstance(ENCRYPT.getAlgorithm(this.asymAlgorithm));
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encodedKey);
            pubKey = KeyFac.generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pubKey;
    }

    public static class EncryptHeader
    extends Header {
        public static final byte ENCRYPT = 1;
        public static final byte KEY_REQUEST = 2;
        public static final byte SECRETKEY = 4;
        public static final byte ENCRYPT_ENTIRE_MSG = 8;
        private byte type;
        protected byte[] version;

        public EncryptHeader() {
        }

        public EncryptHeader(byte type, byte[] version) {
            this.type = type;
            this.version = version;
            if (version == null) {
                throw new IllegalArgumentException("version must be defined");
            }
        }

        public byte getType() {
            return (byte)(this.type & 0xFFFFFFF7);
        }

        protected byte[] getVersion() {
            return this.version;
        }

        public boolean encryptEntireMessage() {
            return Util.isFlagSet(this.type, (byte)8);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            out.writeShort(this.version.length);
            out.write(this.version);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            short len = in.readShort();
            this.version = new byte[len];
            in.readFully(this.version);
        }

        @Override
        public String toString() {
            return "[type=" + this.type + " version=\"" + (this.version != null ? this.version.length + " bytes" : "n/a") + "\"]";
        }

        @Override
        public int size() {
            int retval = 3;
            return retval += this.version.length;
        }
    }

    protected class Decrypter
    implements MessageBatch.Visitor<Message> {
        protected Lock lock;
        protected Cipher cipher;

        protected Decrypter() {
        }

        @Override
        public Message visit(Message msg, MessageBatch batch) {
            EncryptHeader hdr;
            if (msg == null || msg.getLength() == 0 && !ENCRYPT.this.encrypt_entire_message || (hdr = (EncryptHeader)msg.getHeader(ENCRYPT.this.id)) == null) {
                return null;
            }
            if (hdr.getType() == 1) {
                if (ENCRYPT.this.queue_up) {
                    this.queueUpMessage(msg, batch);
                    return null;
                }
                if (!ENCRYPT.this.suppliedKey) {
                    ENCRYPT.this.drainUpQueue();
                }
                if (this.lock == null) {
                    int index = ENCRYPT.this.getNextIndex();
                    this.lock = ENCRYPT.this.decoding_locks[index];
                    this.cipher = ENCRYPT.this.decoding_ciphers[index];
                    this.lock.lock();
                }
                try {
                    Message tmpMsg = ENCRYPT.this.decryptMessage(this.cipher, msg.copy());
                    if (tmpMsg != null) {
                        batch.replace(msg, tmpMsg);
                    }
                }
                catch (Exception e) {
                    ENCRYPT.this.log.error("failed decrypting message from %s (offset=%d, length=%d, buf.length=%d): %s, headers are %s", msg.getSrc(), msg.getOffset(), msg.getLength(), msg.getRawBuffer().length, e, msg.printHeaders());
                }
            } else {
                batch.remove(msg);
                ENCRYPT.this.handleUpEvent(msg, hdr);
            }
            return null;
        }

        protected void unlock() {
            if (this.lock != null) {
                this.lock.unlock();
                this.lock = null;
            }
        }

        protected void queueUpMessage(Message msg, MessageBatch batch) {
            ENCRYPT.this.log.trace("queueing up message as no session key established: " + msg);
            try {
                ENCRYPT.this.upMessageQueue.put(msg);
                batch.remove(msg);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

