/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal.hbm;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.boot.model.TruthValue;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.model.source.spi.ColumnSource;
import org.hibernate.boot.model.source.spi.ConstraintSource;
import org.hibernate.boot.model.source.spi.DerivedValueSource;
import org.hibernate.boot.model.source.spi.IndexConstraintSource;
import org.hibernate.boot.model.source.spi.LocalMetadataBuildingContext;
import org.hibernate.boot.model.source.spi.RelationalValueSource;
import org.hibernate.boot.model.source.spi.UniqueKeyConstraintSource;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;

public class RelationalObjectBinder {
    private final Database database;
    private final PhysicalNamingStrategy physicalNamingStrategy;

    public RelationalObjectBinder(MetadataBuildingContext buildingContext) {
        this.database = buildingContext.getMetadataCollector().getDatabase();
        this.physicalNamingStrategy = buildingContext.getBuildingOptions().getPhysicalNamingStrategy();
    }

    public void bindColumnOrFormula(MappingDocument sourceDocument, RelationalValueSource relationalValueSource, SimpleValue simpleValue, boolean areColumnsNullableByDefault, ColumnNamingDelegate columnNamingDelegate) {
        this.bindColumnsAndFormulas(sourceDocument, Collections.singletonList(relationalValueSource), simpleValue, areColumnsNullableByDefault, columnNamingDelegate);
    }

    public void bindColumns(MappingDocument sourceDocument, List<ColumnSource> columnSources, SimpleValue simpleValue, boolean areColumnsNullableByDefault, ColumnNamingDelegate columnNamingDelegate) {
        for (ColumnSource columnSource : columnSources) {
            this.bindColumn(sourceDocument, columnSource, simpleValue, areColumnsNullableByDefault, columnNamingDelegate);
        }
    }

    public void bindColumnsAndFormulas(MappingDocument sourceDocument, List<RelationalValueSource> relationalValueSources, SimpleValue simpleValue, boolean areColumnsNullableByDefault, ColumnNamingDelegate columnNamingDelegate) {
        for (RelationalValueSource relationalValueSource : relationalValueSources) {
            if (ColumnSource.class.isInstance(relationalValueSource)) {
                ColumnSource columnSource = (ColumnSource)relationalValueSource;
                this.bindColumn(sourceDocument, columnSource, simpleValue, areColumnsNullableByDefault, columnNamingDelegate);
                continue;
            }
            DerivedValueSource formulaSource = (DerivedValueSource)relationalValueSource;
            simpleValue.addFormula(new Formula(formulaSource.getExpression()));
        }
    }

    public void bindColumn(MappingDocument sourceDocument, ColumnSource columnSource, SimpleValue simpleValue, boolean areColumnsNullableByDefault, ColumnNamingDelegate columnNamingDelegate) {
        Table table = simpleValue.getTable();
        Column column = new Column();
        column.setValue(simpleValue);
        Identifier logicalName = StringHelper.isNotEmpty(columnSource.getName()) ? this.database.toIdentifier(columnSource.getName()) : columnNamingDelegate.determineImplicitName(sourceDocument);
        Identifier physicalName = this.physicalNamingStrategy.toPhysicalColumnName(logicalName, this.database.getJdbcEnvironment());
        column.setName(physicalName.render(this.database.getDialect()));
        if (table != null) {
            table.addColumn(column);
            sourceDocument.getMetadataCollector().addColumnNameBinding(table, logicalName, column);
        }
        if (columnSource.getSizeSource() != null) {
            if (columnSource.getSizeSource().getLength() != null) {
                column.setLength(columnSource.getSizeSource().getLength());
            } else {
                column.setLength(255);
            }
            if (columnSource.getSizeSource().getScale() != null) {
                column.setScale(columnSource.getSizeSource().getScale());
            } else {
                column.setScale(2);
            }
            if (columnSource.getSizeSource().getPrecision() != null) {
                column.setPrecision(columnSource.getSizeSource().getPrecision());
            } else {
                column.setPrecision(19);
            }
        }
        column.setNullable(RelationalObjectBinder.interpretNullability(columnSource.isNullable(), areColumnsNullableByDefault));
        column.setUnique(columnSource.isUnique());
        column.setCheckConstraint(columnSource.getCheckCondition());
        column.setDefaultValue(columnSource.getDefaultValue());
        column.setSqlType(columnSource.getSqlType());
        column.setComment(columnSource.getComment());
        column.setCustomRead(columnSource.getReadFragment());
        column.setCustomWrite(columnSource.getWriteFragment());
        simpleValue.addColumn(column);
    }

    private static boolean interpretNullability(TruthValue nullable, boolean areColumnsNullableByDefault) {
        if (nullable == null || nullable == TruthValue.UNKNOWN) {
            return areColumnsNullableByDefault;
        }
        return nullable == TruthValue.TRUE;
    }

    public void bindFormulas(MappingDocument sourceDocument, List<DerivedValueSource> formulaSources, OneToOne oneToOneBinding) {
        for (DerivedValueSource formulaSource : formulaSources) {
            oneToOneBinding.addFormula(new Formula(formulaSource.getExpression()));
        }
    }

    public static void bindConstraints(MappingDocument mappingDocument, RelationalObjectResolutionContext resolutionContext, Collection<ConstraintSource> constraintSources) {
        for (ConstraintSource constraintSource : constraintSources) {
            if (IndexConstraintSource.class.isInstance(constraintSource)) {
                RelationalObjectBinder.bindIndexConstraint(mappingDocument, resolutionContext, (IndexConstraintSource)constraintSource);
                continue;
            }
            if (!UniqueKeyConstraintSource.class.isInstance(constraintSource)) continue;
            RelationalObjectBinder.bindUniqueKeyConstraint(mappingDocument, resolutionContext, (UniqueKeyConstraintSource)constraintSource);
        }
    }

    private static void bindIndexConstraint(MappingDocument mappingDocument, RelationalObjectResolutionContext resolutionContext, IndexConstraintSource constraintSource) {
        Table table = resolutionContext.resolveTable(mappingDocument.getMetadataCollector(), constraintSource.getTableName());
        Index index = table.getOrCreateIndex(constraintSource.name());
        for (String columnName : constraintSource.columnNames()) {
            Column column = resolutionContext.resolveColumn(mappingDocument.getMetadataCollector(), table, columnName);
            index.addColumn(column);
        }
    }

    private static void bindUniqueKeyConstraint(MappingDocument mappingDocument, RelationalObjectResolutionContext resolutionContext, UniqueKeyConstraintSource constraintSource) {
        Table table = resolutionContext.resolveTable(mappingDocument.getMetadataCollector(), constraintSource.getTableName());
        UniqueKey uniqueKey = table.getOrCreateUniqueKey(constraintSource.name());
        for (String columnName : constraintSource.columnNames()) {
            Column column = resolutionContext.resolveColumn(mappingDocument.getMetadataCollector(), table, columnName);
            uniqueKey.addColumn(column);
        }
    }

    public static interface RelationalObjectResolutionContext {
        public Table resolveTable(InFlightMetadataCollector var1, String var2);

        public Column resolveColumn(InFlightMetadataCollector var1, Table var2, String var3);
    }

    public static interface ColumnNamingDelegate {
        public Identifier determineImplicitName(LocalMetadataBuildingContext var1);
    }
}

