/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.security.impl;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.NotificationReceiver;
import io.undertow.security.api.SecurityContext;
import io.undertow.security.api.SecurityNotification;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.SingleSignOn;
import io.undertow.security.impl.SingleSignOnManager;
import io.undertow.server.ConduitWrapper;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.util.ConduitFactory;
import io.undertow.util.Sessions;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.xnio.conduits.StreamSinkConduit;

public class SingleSignOnAuthenticationMechanism
implements AuthenticationMechanism {
    private static final String SSO_SESSION_ATTRIBUTE = SingleSignOnAuthenticationMechanism.class.getName() + ".SSOID";
    private final Set<SessionManager> seenSessionManagers = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private String cookieName = "JSESSIONIDSSO";
    private boolean httpOnly;
    private boolean secure;
    private String domain;
    private String path;
    private final SessionInvalidationListener listener = new SessionInvalidationListener();
    private final ResponseListener responseListener = new ResponseListener();
    private final SingleSignOnManager singleSignOnManager;
    private final IdentityManager identityManager;

    public SingleSignOnAuthenticationMechanism(SingleSignOnManager storage) {
        this(storage, null);
    }

    public SingleSignOnAuthenticationMechanism(SingleSignOnManager storage, IdentityManager identityManager) {
        this.singleSignOnManager = storage;
        this.identityManager = identityManager;
    }

    private IdentityManager getIdentityManager(SecurityContext securityContext) {
        return this.identityManager != null ? this.identityManager : securityContext.getIdentityManager();
    }

    @Override
    public AuthenticationMechanism.AuthenticationMechanismOutcome authenticate(HttpServerExchange exchange, SecurityContext securityContext) {
        Cookie cookie = exchange.getRequestCookies().get(this.cookieName);
        if (cookie != null) {
            String ssoId = cookie.getValue();
            try (final SingleSignOn sso = this.singleSignOnManager.findSingleSignOn(ssoId);){
                if (sso != null) {
                    Account verified = this.getIdentityManager(securityContext).verify(sso.getAccount());
                    if (verified == null) {
                        AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
                        return authenticationMechanismOutcome;
                    }
                    Session session = this.getSession(exchange);
                    this.registerSessionIfRequired(sso, session);
                    securityContext.authenticationComplete(verified, sso.getMechanismName(), false);
                    securityContext.registerNotificationReceiver(new NotificationReceiver(){

                        @Override
                        public void handleNotification(SecurityNotification notification) {
                            if (notification.getEventType() == SecurityNotification.EventType.LOGGED_OUT) {
                                SingleSignOnAuthenticationMechanism.this.singleSignOnManager.removeSingleSignOn(sso);
                            }
                        }
                    });
                    AuthenticationMechanism.AuthenticationMechanismOutcome authenticationMechanismOutcome = AuthenticationMechanism.AuthenticationMechanismOutcome.AUTHENTICATED;
                    return authenticationMechanismOutcome;
                }
            }
            this.clearSsoCookie(exchange);
        }
        exchange.addResponseWrapper(this.responseListener);
        return AuthenticationMechanism.AuthenticationMechanismOutcome.NOT_ATTEMPTED;
    }

    private void registerSessionIfRequired(SingleSignOn sso, Session session) {
        if (!sso.contains(session)) {
            sso.add(session);
            session.setAttribute(SSO_SESSION_ATTRIBUTE, sso.getId());
            SessionManager manager = session.getSessionManager();
            if (this.seenSessionManagers.add(manager)) {
                manager.registerSessionListener(this.listener);
            }
        }
    }

    private void clearSsoCookie(HttpServerExchange exchange) {
        exchange.getResponseCookies().put(this.cookieName, new CookieImpl(this.cookieName).setMaxAge(0).setHttpOnly(this.httpOnly).setSecure(this.secure).setDomain(this.domain));
    }

    @Override
    public AuthenticationMechanism.ChallengeResult sendChallenge(HttpServerExchange exchange, SecurityContext securityContext) {
        return new AuthenticationMechanism.ChallengeResult(false);
    }

    protected Session getSession(HttpServerExchange exchange) {
        return Sessions.getOrCreateSession(exchange);
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public SingleSignOnAuthenticationMechanism setCookieName(String cookieName) {
        this.cookieName = cookieName;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public SingleSignOnAuthenticationMechanism setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public SingleSignOnAuthenticationMechanism setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public SingleSignOnAuthenticationMechanism setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public SingleSignOnAuthenticationMechanism setPath(String path) {
        this.path = path;
        return this;
    }

    final class SessionInvalidationListener
    implements SessionListener {
        SessionInvalidationListener() {
        }

        @Override
        public void sessionCreated(Session session, HttpServerExchange exchange) {
        }

        @Override
        public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
            String ssoId = (String)session.getAttribute(SSO_SESSION_ATTRIBUTE);
            if (ssoId != null) {
                try (SingleSignOn sso = SingleSignOnAuthenticationMechanism.this.singleSignOnManager.findSingleSignOn(ssoId);){
                    if (sso != null) {
                        sso.remove(session);
                        if (reason == SessionListener.SessionDestroyedReason.INVALIDATED) {
                            for (Session associatedSession : sso) {
                                associatedSession.invalidate(null);
                                sso.remove(associatedSession);
                            }
                        }
                        if (!sso.iterator().hasNext()) {
                            SingleSignOnAuthenticationMechanism.this.singleSignOnManager.removeSingleSignOn(sso);
                        }
                    }
                }
            }
        }

        @Override
        public void attributeAdded(Session session, String name, Object value) {
        }

        @Override
        public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
        }

        @Override
        public void attributeRemoved(Session session, String name, Object oldValue) {
        }

        @Override
        public void sessionIdChanged(Session session, String oldSessionId) {
        }
    }

    final class ResponseListener
    implements ConduitWrapper<StreamSinkConduit> {
        ResponseListener() {
        }

        @Override
        public StreamSinkConduit wrap(ConduitFactory<StreamSinkConduit> factory, HttpServerExchange exchange) {
            SecurityContext sc = exchange.getSecurityContext();
            Account account = sc.getAuthenticatedAccount();
            if (account != null) {
                try (SingleSignOn sso = SingleSignOnAuthenticationMechanism.this.singleSignOnManager.createSingleSignOn(account, sc.getMechanismName());){
                    Session session = SingleSignOnAuthenticationMechanism.this.getSession(exchange);
                    SingleSignOnAuthenticationMechanism.this.registerSessionIfRequired(sso, session);
                    exchange.getResponseCookies().put(SingleSignOnAuthenticationMechanism.this.cookieName, new CookieImpl(SingleSignOnAuthenticationMechanism.this.cookieName, sso.getId()).setHttpOnly(SingleSignOnAuthenticationMechanism.this.httpOnly).setSecure(SingleSignOnAuthenticationMechanism.this.secure).setDomain(SingleSignOnAuthenticationMechanism.this.domain).setPath(SingleSignOnAuthenticationMechanism.this.path));
                }
            }
            return factory.create();
        }
    }
}

