/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.endpoint.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;

public enum Attribute {
    UNKNOWN((String)null),
    AWAIT_INITIAL_RETRIEVAL("await-initial-retrieval"),
    AUTH_METHOD("auth-method"),
    CONTEXT_PATH("context-path"),
    CACHE("cache"),
    CACHE_CONTAINER("cache-container"),
    IGNORED_CACHES("ignored-caches"),
    EXTENDED_HEADERS("extended-headers"),
    EXTERNAL_HOST("external-host"),
    EXTERNAL_PORT("external-port"),
    IDLE_TIMEOUT("idle-timeout"),
    MECHANISMS("mechanisms"),
    LAZY_RETRIEVAL("lazy-retrieval"),
    LOCK_TIMEOUT("lock-timeout"),
    REPLICATION_TIMEOUT("replication-timeout"),
    NAME("name"),
    QOP("qop"),
    RECEIVE_BUFFER_SIZE("receive-buffer-size"),
    REQUIRE_SSL_CLIENT_AUTH("require-ssl-client-auth"),
    SEND_BUFFER_SIZE("send-buffer-size"),
    SECURITY_DOMAIN("security-domain"),
    SECURITY_MODE("security-mode"),
    SECURITY_REALM("security-realm"),
    SERVER_CONTEXT_NAME("server-context-name"),
    SERVER_NAME("server-name"),
    SOCKET_BINDING("socket-binding"),
    SSL("ssl"),
    STRENGTH("strength"),
    TCP_NODELAY("tcp-nodelay"),
    UPDATE_TIMEOUT("update-timeout"),
    VALUE("value"),
    VIRTUAL_HOST("virtual-host"),
    VIRTUAL_SERVER("virtual-server"),
    WORKER_THREADS("worker-threads");

    private final String name;
    private final AttributeDefinition definition;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
        this.definition = null;
    }

    private Attribute(AttributeDefinition definition) {
        this.name = definition.getXmlName();
        this.definition = definition;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>();
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

