/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import java.util.HashSet;
import java.util.Map;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;

public abstract class BaseQuery
implements Query {
    protected final QueryFactory queryFactory;
    protected final String jpaQuery;
    protected final Map<String, Object> namedParameters;
    protected final String[] projection;
    protected final int startOffset;
    protected final int maxResults;

    protected BaseQuery(QueryFactory queryFactory, String jpaQuery, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults) {
        this.queryFactory = queryFactory;
        this.jpaQuery = jpaQuery;
        this.namedParameters = namedParameters;
        this.projection = projection != null && projection.length > 0 ? projection : null;
        this.startOffset = startOffset < 0L ? 0 : (int)startOffset;
        this.maxResults = maxResults;
    }

    public QueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    public String getJPAQuery() {
        return this.jpaQuery;
    }

    @Override
    public Query setParameter(String paramName, Object paramValue) {
        if (this.namedParameters == null) {
            throw new IllegalStateException("Query does not have parameters");
        }
        if (!this.namedParameters.containsKey(paramName)) {
            throw new IllegalArgumentException("No parameter named '" + paramName + "' was found");
        }
        this.namedParameters.put(paramName, paramValue);
        this.resetQuery();
        return this;
    }

    @Override
    public Query setParameters(Map<String, Object> paramValues) {
        if (paramValues == null) {
            throw new IllegalArgumentException("paramValues cannot be null");
        }
        if (this.namedParameters == null) {
            throw new IllegalStateException("Query does not have parameters");
        }
        if (!this.namedParameters.keySet().containsAll(paramValues.keySet())) {
            HashSet<String> unknownParams = new HashSet<String>(paramValues.keySet());
            unknownParams.removeAll(this.namedParameters.keySet());
            throw new IllegalArgumentException("No parameters named '" + unknownParams + "' were found");
        }
        this.namedParameters.putAll(paramValues);
        this.resetQuery();
        return this;
    }

    public abstract void resetQuery();

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters;
    }

    public String[] getProjection() {
        return this.projection;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public int getMaxResults() {
        return this.maxResults;
    }
}

