/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan;

import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.infinispan.Mutator;

public class CacheEntryMutator<K, V>
implements Mutator {
    private final Cache<K, V> cache;
    private final K id;
    private final V value;
    private final AtomicBoolean mutated;

    public CacheEntryMutator(Cache<K, V> cache, K id, V value) {
        this.cache = cache;
        this.id = id;
        this.value = value;
        this.mutated = cache.getCacheConfiguration().transaction().transactionMode().isTransactional() ? new AtomicBoolean(false) : null;
    }

    @Override
    public void mutate() {
        if (this.mutated == null || this.mutated.compareAndSet(false, true)) {
            this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).replace(this.id, this.value);
        }
    }
}

