/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Properties;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.indexes.impl.NRTIndexManager;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultIndexManagerFactory
implements IndexManagerFactory,
Startable {
    private static final Log log = LoggerFactory.make();
    private ServiceManager serviceManager;

    @Override
    public IndexManager createDefaultIndexManager() {
        return new DirectoryBasedIndexManager();
    }

    @Override
    public IndexManager createIndexManagerByName(String indexManagerImplementationName) {
        if (StringHelper.isEmpty(indexManagerImplementationName)) {
            return this.createDefaultIndexManager();
        }
        IndexManager indexManager = this.fromAlias(indexManagerImplementationName = indexManagerImplementationName.trim());
        if (indexManager == null) {
            indexManagerImplementationName = this.aliasToFQN(indexManagerImplementationName);
            Class indexManagerClass = ClassLoaderHelper.classForName(indexManagerImplementationName, this.serviceManager);
            indexManager = ClassLoaderHelper.instanceFromClass(IndexManager.class, indexManagerClass, "index manager");
        }
        log.indexManagerAliasResolved(indexManagerImplementationName, indexManager.getClass());
        return indexManager;
    }

    @Override
    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
    }

    protected String aliasToFQN(String alias) {
        return alias;
    }

    protected IndexManager fromAlias(String alias) {
        if ("directory-based".equals(alias)) {
            return new DirectoryBasedIndexManager();
        }
        if ("near-real-time".equals(alias)) {
            return new NRTIndexManager();
        }
        return null;
    }
}

