/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.impl.operations.AddClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetKeysOperation;
import org.infinispan.client.hotrod.impl.operations.BulkGetOperation;
import org.infinispan.client.hotrod.impl.operations.ClearOperation;
import org.infinispan.client.hotrod.impl.operations.ContainsKeyOperation;
import org.infinispan.client.hotrod.impl.operations.ExecuteOperation;
import org.infinispan.client.hotrod.impl.operations.FaultTolerantPingOperation;
import org.infinispan.client.hotrod.impl.operations.GetAllOperation;
import org.infinispan.client.hotrod.impl.operations.GetOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithMetadataOperation;
import org.infinispan.client.hotrod.impl.operations.GetWithVersionOperation;
import org.infinispan.client.hotrod.impl.operations.IterationEndOperation;
import org.infinispan.client.hotrod.impl.operations.IterationNextOperation;
import org.infinispan.client.hotrod.impl.operations.IterationStartOperation;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.operations.PutAllOperation;
import org.infinispan.client.hotrod.impl.operations.PutIfAbsentOperation;
import org.infinispan.client.hotrod.impl.operations.PutOperation;
import org.infinispan.client.hotrod.impl.operations.QueryOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveClientListenerOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.RemoveOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceIfUnmodifiedOperation;
import org.infinispan.client.hotrod.impl.operations.ReplaceOperation;
import org.infinispan.client.hotrod.impl.operations.SizeOperation;
import org.infinispan.client.hotrod.impl.operations.StatsOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

@Immutable
public class OperationsFactory
implements HotRodConstants {
    private final ThreadLocal<Integer> flagsMap = new ThreadLocal();
    private final TransportFactory transportFactory;
    private final byte[] cacheNameBytes;
    private final AtomicInteger topologyId;
    private final boolean forceReturnValue;
    private final Codec codec;
    private final ClientListenerNotifier listenerNotifier;
    private final String cacheName;

    public OperationsFactory(TransportFactory transportFactory, String cacheName, boolean forceReturnValue, Codec codec, ClientListenerNotifier listenerNotifier) {
        this.transportFactory = transportFactory;
        this.cacheNameBytes = RemoteCacheManager.cacheNameBytes(cacheName);
        this.cacheName = cacheName;
        this.topologyId = transportFactory != null ? transportFactory.createTopologyId(this.cacheNameBytes) : new AtomicInteger(-1);
        this.forceReturnValue = forceReturnValue;
        this.codec = codec;
        this.listenerNotifier = listenerNotifier;
    }

    public ClientListenerNotifier getListenerNotifier() {
        return this.listenerNotifier;
    }

    public byte[] getCacheName() {
        return this.cacheNameBytes;
    }

    public <V> GetOperation<V> newGetKeyOperation(byte[] key) {
        return new GetOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public <K, V> GetAllOperation<K, V> newGetAllOperation(Set<byte[]> keys) {
        return new GetAllOperation(this.codec, this.transportFactory, keys, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public <V> RemoveOperation<V> newRemoveOperation(byte[] key) {
        return new RemoveOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public <V> RemoveIfUnmodifiedOperation<V> newRemoveIfUnmodifiedOperation(byte[] key, long version) {
        return new RemoveIfUnmodifiedOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(), version);
    }

    public ReplaceIfUnmodifiedOperation newReplaceIfUnmodifiedOperation(byte[] key, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit, long version) {
        return new ReplaceIfUnmodifiedOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit, version);
    }

    public <V> GetWithVersionOperation<V> newGetWithVersionOperation(byte[] key) {
        return new GetWithVersionOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public <V> GetWithMetadataOperation<V> newGetWithMetadataOperation(byte[] key) {
        return new GetWithMetadataOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public StatsOperation newStatsOperation() {
        return new StatsOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public <V> PutOperation<V> newPutKeyValueOperation(byte[] key, byte[] value, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        return new PutOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), value, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit);
    }

    public PutAllOperation newPutAllOperation(Map<byte[], byte[]> map, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        return new PutAllOperation(this.codec, this.transportFactory, map, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit);
    }

    public <V> PutIfAbsentOperation<V> newPutIfAbsentOperation(byte[] key, byte[] value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        return new PutIfAbsentOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdleTime), value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
    }

    public <V> ReplaceOperation<V> newReplaceOperation(byte[] key, byte[] values, long lifespan, TimeUnit lifespanTimeUnit, long maxIdle, TimeUnit maxIdleTimeUnit) {
        return new ReplaceOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags(lifespan, maxIdle), values, lifespan, lifespanTimeUnit, maxIdle, maxIdleTimeUnit);
    }

    public ContainsKeyOperation newContainsKeyOperation(byte[] key) {
        return new ContainsKeyOperation(this.codec, this.transportFactory, key, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public ClearOperation newClearOperation() {
        return new ClearOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public <K, V> BulkGetOperation<K, V> newBulkGetOperation(int size) {
        return new BulkGetOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), size);
    }

    public <K> BulkGetKeysOperation<K> newBulkGetKeysOperation(int scope) {
        return new BulkGetKeysOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), scope);
    }

    public AddClientListenerOperation newAddClientListenerOperation(Object listener) {
        return new AddClientListenerOperation(this.codec, this.transportFactory, this.cacheName, this.topologyId, this.flags(), this.listenerNotifier, listener, null, null);
    }

    public AddClientListenerOperation newAddClientListenerOperation(Object listener, byte[][] filterFactoryParams, byte[][] converterFactoryParams) {
        return new AddClientListenerOperation(this.codec, this.transportFactory, this.cacheName, this.topologyId, this.flags(), this.listenerNotifier, listener, filterFactoryParams, converterFactoryParams);
    }

    public RemoveClientListenerOperation newRemoveClientListenerOperation(Object listener) {
        return new RemoveClientListenerOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), this.listenerNotifier, listener);
    }

    public PingOperation newPingOperation(Transport transport) {
        return new PingOperation(this.codec, this.topologyId, transport, this.cacheNameBytes);
    }

    public FaultTolerantPingOperation newFaultTolerantPingOperation() {
        return new FaultTolerantPingOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public QueryOperation newQueryOperation(RemoteQuery remoteQuery) {
        return new QueryOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), remoteQuery);
    }

    public SizeOperation newSizeOperation() {
        return new SizeOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags());
    }

    public <T> ExecuteOperation<T> newExecuteOperation(String taskName, Map<String, byte[]> marshalledParams) {
        return new ExecuteOperation(this.codec, this.transportFactory, this.cacheNameBytes, this.topologyId, this.flags(), taskName, marshalledParams);
    }

    private int flags(long lifespan, long maxIdle) {
        int intFlags = this.flags();
        if (lifespan == 0L) {
            intFlags |= Flag.DEFAULT_LIFESPAN.getFlagInt();
        }
        if (maxIdle == 0L) {
            intFlags |= Flag.DEFAULT_MAXIDLE.getFlagInt();
        }
        return intFlags;
    }

    public int flags() {
        Integer threadLocalFlags = this.flagsMap.get();
        this.flagsMap.remove();
        int intFlags = 0;
        if (threadLocalFlags != null) {
            intFlags |= threadLocalFlags.intValue();
        }
        if (this.forceReturnValue) {
            intFlags |= Flag.FORCE_RETURN_VALUE.getFlagInt();
        }
        return intFlags;
    }

    public void setFlags(Flag[] flags) {
        int intFlags = 0;
        for (Flag flag : flags) {
            intFlags |= flag.getFlagInt();
        }
        this.flagsMap.set(intFlags);
    }

    public void setFlags(int intFlags) {
        this.flagsMap.set(intFlags);
    }

    public void addFlag(Flag flag) {
        int intFlags = flag.getFlagInt();
        Integer threadLocalFlags = this.flagsMap.get();
        if (threadLocalFlags != null) {
            intFlags |= threadLocalFlags.intValue();
        }
        this.flagsMap.set(intFlags);
    }

    public boolean hasFlag(Flag flag) {
        Integer threadLocalFlags = this.flagsMap.get();
        return threadLocalFlags != null && (threadLocalFlags & flag.getFlagInt()) != 0;
    }

    public CacheTopologyInfo getCacheTopologyInfo() {
        return this.transportFactory.getCacheTopologyInfo(this.cacheNameBytes);
    }

    public IterationStartOperation newIterationStartOperation(String filterConverterFactory, byte[][] filterParameters, Set<Integer> segments, int batchSize) {
        return new IterationStartOperation(this.codec, this.flags(), this.cacheNameBytes, this.topologyId, filterConverterFactory, filterParameters, segments, batchSize, this.transportFactory);
    }

    public IterationEndOperation newIterationEndOperation(String iterationId, Transport transport) {
        return new IterationEndOperation(this.codec, this.flags(), this.cacheNameBytes, this.topologyId, iterationId, this.transportFactory, transport);
    }

    public <K, V> IterationNextOperation newIterationNextOperation(String iterationId, Transport transport) {
        return new IterationNextOperation(this.codec, this.flags(), this.cacheNameBytes, this.topologyId, iterationId, transport);
    }
}

