/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.ManagedConnection;
import javax.transaction.SystemException;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.listener.ConnectionCacheListener;
import org.jboss.jca.core.api.connectionmanager.pool.FlushMode;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.ConnectionState;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.spi.transaction.ConnectableResourceListener;
import org.jboss.jca.core.tracer.Tracer;
import org.jboss.logging.Messages;

public abstract class AbstractConnectionListener
implements ConnectionListener,
ConnectableResourceListener {
    private final CoreLogger log;
    protected boolean trace;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private final ConnectionManager cm;
    private final ManagedConnection managedConnection;
    private final Pool pool;
    private final ManagedConnectionPool managedConnectionPool;
    private FlushStrategy flushStrategy;
    private ConnectionState state = ConnectionState.NORMAL;
    protected CopyOnWriteArraySet<Object> connectionHandles = new CopyOnWriteArraySet();
    protected Map<Object, Exception> connectionTraces;
    private final AtomicBoolean trackByTx = new AtomicBoolean(false);
    private long lastReturned;
    private long lastValidated;
    private long lastCheckedOut;
    private boolean enlisted;
    protected Boolean tracking;
    private Exception reportedException;

    protected AbstractConnectionListener(ConnectionManager cm, ManagedConnection managedConnection, Pool pool, ManagedConnectionPool mcp, FlushStrategy flushStrategy, Boolean tracking) {
        long createdTime;
        this.cm = cm;
        this.managedConnection = managedConnection;
        this.pool = pool;
        this.managedConnectionPool = mcp;
        this.flushStrategy = flushStrategy;
        this.log = this.getLogger();
        this.trace = this.log.isTraceEnabled();
        this.enlisted = false;
        this.lastReturned = createdTime = System.currentTimeMillis();
        this.lastValidated = createdTime;
        this.lastCheckedOut = createdTime;
        this.tracking = tracking;
        if (tracking != null && tracking.booleanValue()) {
            this.connectionTraces = new HashMap<Object, Exception>();
        }
        this.reportedException = null;
    }

    protected CachedConnectionManager getCachedConnectionManager() {
        return this.cm.getCachedConnectionManager();
    }

    protected ConnectionManager getConnectionManager() {
        return this.cm;
    }

    protected abstract CoreLogger getLogger();

    @Override
    public int getNumberOfConnections() {
        return this.connectionHandles.size();
    }

    @Override
    public boolean isEnlisted() {
        return this.enlisted;
    }

    void setEnlisted(boolean v) {
        this.enlisted = v;
    }

    @Override
    public boolean delist() throws ResourceException {
        return true;
    }

    @Override
    public void enlist() throws SystemException {
    }

    @Override
    public ManagedConnectionPool getManagedConnectionPool() {
        return this.managedConnectionPool;
    }

    @Override
    public long getLastValidatedTime() {
        return this.lastValidated;
    }

    @Override
    public long getLastReturnedTime() {
        return this.lastReturned;
    }

    @Override
    public long getLastCheckedOutTime() {
        return this.lastCheckedOut;
    }

    @Override
    public void setLastCheckedOutTime(long v) {
        this.lastCheckedOut = v;
    }

    public ManagedConnection getManagedConnection() {
        return this.managedConnection;
    }

    @Override
    public Pool getPool() {
        return this.pool;
    }

    @Override
    public ConnectionState getState() {
        return this.state;
    }

    @Override
    public boolean isManagedConnectionFree() {
        if (this.trace) {
            this.log.tracef("[%s] isManagedConnectionFree: %s", this.getIdentifier(), this.connectionHandles.isEmpty());
        }
        return this.connectionHandles.isEmpty();
    }

    @Override
    public boolean isTimedOut(long timeout) {
        return this.lastReturned < timeout;
    }

    @Override
    public boolean isTrackByTx() {
        return this.trackByTx.get();
    }

    @Override
    public void registerConnection(Object handle) {
        if (handle != null) {
            this.connectionHandles.add(handle);
            if (Tracer.isEnabled()) {
                Tracer.getConnection(this.pool != null ? this.pool.getName() : null, this.managedConnectionPool, this, handle);
            }
            if (this.trace) {
                this.log.tracef("[%s] registerConnection: %s [size=%s] (%s)", new Object[]{this.getIdentifier(), handle, this.connectionHandles.size(), this.connectionHandles});
            }
            if (this.tracking != null && this.tracking.booleanValue()) {
                this.connectionTraces.put(handle, new Exception());
            }
        } else {
            this.log.registeredNullHandleManagedConnection(this.managedConnection);
        }
    }

    @Override
    public void setLastValidatedTime(long lastValidated) {
        this.lastValidated = lastValidated;
    }

    @Override
    public void setState(ConnectionState newState) {
        this.state = newState;
    }

    @Override
    public void setTrackByTx(boolean trackByTx) {
        this.trackByTx.set(trackByTx);
    }

    @Override
    public void tidyup() throws ResourceException {
    }

    @Override
    public void unregisterConnection(Object handle) {
        if (handle != null) {
            if (!this.connectionHandles.remove(handle)) {
                this.log.unregisteredHandleNotRegistered(handle, this.managedConnection);
            }
            if (Tracer.isEnabled()) {
                Tracer.returnConnection(this.pool != null ? this.pool.getName() : null, this.managedConnectionPool, this, handle);
            }
            if (this.tracking != null && this.tracking.booleanValue()) {
                this.connectionTraces.remove(handle);
            }
        } else {
            this.log.unregisteredNullHandleManagedConnection(this.managedConnection);
        }
        if (this.trace) {
            this.log.tracef("[%s] unregisterConnection: " + this.connectionHandles.size() + " handles left (%s)", this.getIdentifier(), this.connectionHandles);
        }
    }

    @Override
    public void unregisterConnections() {
        if (this.trace) {
            this.log.tracef("[%s] unregisterConnections", this.getIdentifier());
        }
        if (this.getCachedConnectionManager() != null) {
            for (Object handle : this.connectionHandles) {
                this.getCachedConnectionManager().unregisterConnection((ConnectionCacheListener)this.getConnectionManager(), (org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener)this, handle);
            }
        }
        if (Tracer.isEnabled()) {
            for (Object handle : this.connectionHandles) {
                Tracer.returnConnection(this.pool != null ? this.pool.getName() : null, this.managedConnectionPool, this, handle);
            }
        }
        this.connectionHandles.clear();
        if (this.tracking != null && this.tracking.booleanValue()) {
            this.connectionTraces.clear();
        }
    }

    @Override
    public void toPool() {
        this.lastReturned = System.currentTimeMillis();
    }

    public void connectionClosed(ConnectionEvent event) {
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        if (this.state == ConnectionState.NORMAL) {
            if (event != null) {
                Exception cause = event.getException();
                if (cause == null) {
                    cause = new Exception("No exception was reported");
                } else {
                    this.reportedException = cause;
                }
                this.log.connectionErrorOccured(this, cause);
            } else {
                Exception cause = new Exception("No exception was reported");
                this.log.unknownConnectionErrorOccured(this, cause);
            }
        }
        try {
            this.unregisterConnections();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (event != null && event.getSource() != this.getManagedConnection()) {
            this.log.notifiedErrorDifferentManagedConnection();
        }
        this.haltCatchFire();
        this.getConnectionManager().returnManagedConnection(this, true);
        if (this.flushStrategy == FlushStrategy.FAILING_CONNECTION_ONLY) {
            this.managedConnectionPool.prefill();
        } else if (this.flushStrategy == FlushStrategy.INVALID_IDLE_CONNECTIONS) {
            this.managedConnectionPool.flush(FlushMode.INVALID);
        } else if (this.flushStrategy == FlushStrategy.IDLE_CONNECTIONS) {
            this.managedConnectionPool.flush(FlushMode.IDLE);
        } else if (this.flushStrategy == FlushStrategy.GRACEFULLY) {
            this.managedConnectionPool.flush(FlushMode.GRACEFULLY);
        } else if (this.flushStrategy == FlushStrategy.ENTIRE_POOL) {
            this.managedConnectionPool.flush(FlushMode.ALL);
        } else if (this.flushStrategy == FlushStrategy.ALL_INVALID_IDLE_CONNECTIONS) {
            this.pool.flush(FlushMode.INVALID);
        } else if (this.flushStrategy == FlushStrategy.ALL_IDLE_CONNECTIONS) {
            this.pool.flush(FlushMode.IDLE);
        } else if (this.flushStrategy == FlushStrategy.ALL_GRACEFULLY) {
            this.pool.flush(FlushMode.GRACEFULLY);
        } else if (this.flushStrategy == FlushStrategy.ALL_CONNECTIONS) {
            this.pool.flush(FlushMode.ALL);
        }
    }

    @Override
    public Exception getException() {
        return this.reportedException;
    }

    @Override
    public boolean controls(ManagedConnection mc, Object connection) {
        return this.managedConnection.equals(mc) && (connection == null || this.connectionHandles.contains(connection));
    }

    @Override
    public void dissociate() throws ResourceException {
    }

    @Override
    public boolean supportsLazyAssociation() {
        return this.managedConnection instanceof DissociatableManagedConnection;
    }

    @Override
    public boolean supportsLazyEnlistment() {
        return this.managedConnection instanceof LazyEnlistableManagedConnection;
    }

    public void localTransactionCommitted(ConnectionEvent event) {
    }

    public void localTransactionRolledback(ConnectionEvent event) {
    }

    public void localTransactionStarted(ConnectionEvent event) {
    }

    public void handleCreated(Object h) {
        this.registerConnection(h);
        if (this.getCachedConnectionManager() != null) {
            this.getCachedConnectionManager().registerConnection((ConnectionCacheListener)this.getConnectionManager(), (org.jboss.jca.core.api.connectionmanager.listener.ConnectionListener)this, h);
        }
    }

    public void handleClosed(Object h) {
    }

    void haltCatchFire() {
    }

    public int compareTo(Object o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof AbstractConnectionListener)) {
            throw new ClassCastException(bundle.notCorrectTypeWhenClassCast(o.getClass().getName()));
        }
        AbstractConnectionListener acl = (AbstractConnectionListener)o;
        if (this.lastReturned < acl.lastReturned) {
            return -1;
        }
        return 1;
    }

    private String getIdentifier() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass().getSimpleName()).append('@').append(Integer.toHexString(System.identityHashCode(this)));
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass().getName()).append('@').append(Integer.toHexString(System.identityHashCode(this)));
        buffer.append("[state=");
        if (this.state.equals((Object)ConnectionState.NORMAL)) {
            buffer.append("NORMAL");
        } else if (this.state.equals((Object)ConnectionState.DESTROY)) {
            buffer.append("DESTROY");
        } else if (this.state.equals((Object)ConnectionState.DESTROYED)) {
            buffer.append("DESTROYED");
        } else {
            buffer.append("UNKNOWN?");
        }
        buffer.append(" managed connection=").append(this.managedConnection);
        buffer.append(" connection handles=").append(this.connectionHandles.size());
        buffer.append(" lastReturned=").append(this.lastReturned);
        buffer.append(" lastValidated=").append(this.lastValidated);
        buffer.append(" lastCheckedOut=").append(this.lastCheckedOut);
        buffer.append(" trackByTx=").append(this.trackByTx.get());
        buffer.append(" pool=").append(this.pool);
        buffer.append(" mcp=").append(this.managedConnectionPool);
        this.toString(buffer);
        buffer.append(']');
        return buffer.toString();
    }

    protected void toString(StringBuffer buffer) {
    }
}

