/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.Driver;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.JdbcUtils;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

public class Script
extends Tool {
    public static void main(String ... stringArray) throws SQLException {
        new Script().runTool(stringArray);
    }

    @Override
    public void runTool(String ... stringArray) throws SQLException {
        String string = null;
        String string2 = "sa";
        String string3 = "";
        String string4 = "backup.sql";
        String string5 = null;
        String string6 = null;
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            String string7 = stringArray[i];
            if (string7.equals("-url")) {
                string = stringArray[++i];
                continue;
            }
            if (string7.equals("-user")) {
                string2 = stringArray[++i];
                continue;
            }
            if (string7.equals("-password")) {
                string3 = stringArray[++i];
                continue;
            }
            if (string7.equals("-script")) {
                string4 = stringArray[++i];
                continue;
            }
            if (string7.equals("-options")) {
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = new StringBuilder();
                ++i;
                while (i < stringArray.length) {
                    String string8 = stringArray[i];
                    String string9 = StringUtils.toUpperEnglish(string8);
                    if ("SIMPLE".equals(string9) || string9.startsWith("NO") || "DROP".equals(string9)) {
                        stringBuilder.append(' ');
                        stringBuilder.append(stringArray[i]);
                    } else {
                        stringBuilder2.append(' ');
                        stringBuilder2.append(stringArray[i]);
                    }
                    ++i;
                }
                string5 = stringBuilder.toString();
                string6 = stringBuilder2.toString();
                continue;
            }
            if (string7.equals("-help") || string7.equals("-?")) {
                this.showUsage();
                return;
            }
            this.showUsageAndThrowUnsupportedOption(string7);
        }
        if (string == null) {
            this.showUsage();
            throw new SQLException("URL not set");
        }
        if (string5 != null) {
            Script.processScript(string, string2, string3, string4, string5, string6);
        } else {
            Script.execute(string, string2, string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processScript(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Connection connection = null;
        Statement statement = null;
        try {
            Driver.load();
            connection = DriverManager.getConnection(string, string2, string3);
            statement = connection.createStatement();
            String string7 = "SCRIPT " + string5 + " TO '" + string4 + "' " + string6;
            statement.execute(string7);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(statement);
            JdbcUtils.closeSilently(connection);
            throw throwable;
        }
        JdbcUtils.closeSilently(statement);
        JdbcUtils.closeSilently(connection);
    }

    public static void execute(String string, String string2, String string3, String string4) throws SQLException {
        OutputStream outputStream = null;
        try {
            outputStream = FileUtils.newOutputStream(string4, false);
            Script.execute(string, string2, string3, outputStream);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, null);
        }
        finally {
            IOUtils.closeSilently(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String string, String string2, String string3, OutputStream outputStream) throws SQLException {
        Connection connection = null;
        try {
            Driver.load();
            connection = DriverManager.getConnection(string, string2, string3);
            Script.process(connection, outputStream);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeSilently(connection);
            throw throwable;
        }
        JdbcUtils.closeSilently(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void process(Connection connection, OutputStream outputStream) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            PrintWriter printWriter = new PrintWriter(IOUtils.getBufferedWriter(outputStream));
            ResultSet resultSet = statement.executeQuery("SCRIPT");
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                printWriter.println(string);
            }
            printWriter.flush();
        }
        finally {
            JdbcUtils.closeSilently(statement);
        }
    }
}

